/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.work;

import de.digitalcollections.cudami.admin.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTRequest;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTResponse;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.work.CudamiItemsClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.UUID;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ItemsAPIController
extends AbstractEntitiesController<Item, CudamiItemsClient> {
    public ItemsAPIController(LanguageService languageService, CudamiClient client) {
        super((CudamiEntitiesClient)client.forItems(), languageService);
    }

    @GetMapping(value={"/api/items"})
    @ResponseBody
    @SuppressFBWarnings
    public BTResponse<Item> find(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException, ServiceException {
        return this.find(Item.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
    }

    @GetMapping(value={"/api/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects"})
    @ResponseBody
    public BTResponse<DigitalObject> findDigitalObjects(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(DigitalObject.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiItemsClient)this.service).findDigitalObjects(uuid, (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/children"})
    @ResponseBody
    public BTResponse<Item> findEmbeddedItems(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        Item parentItem = ((Item.ItemBuilder)Item.builder().uuid(uuid)).build();
        BTRequest btRequest = this.createBTRequest(DigitalObject.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiItemsClient)this.service).getAllForParent(parentItem, (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }
}

