/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.work;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.work.CudamiItemsClient;
import de.digitalcollections.cudami.client.identifiable.entity.work.CudamiManifestationsClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.identifiable.entity.manifestation.Manifestation;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ItemsController
extends AbstractEntitiesController<Item, CudamiItemsClient> {
    private final CudamiManifestationsClient manifestationsService;

    public ItemsController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forItems(), languageService);
        this.manifestationsService = client.forManifestations();
    }

    @GetMapping(value={"/items"})
    public String list(Model model) throws TechnicalException {
        model.addAttribute("existingLanguages", (Object)this.getExistingLanguagesFromService());
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "items/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "items";
    }

    @GetMapping(value={"/items/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        Item item = (Item)this.service.getByUuid(uuid);
        if (item == null) {
            throw new ResourceNotFoundException();
        }
        if (item.getManifestation() != null) {
            item.setManifestation((Manifestation)this.manifestationsService.getByUuid(item.getManifestation().getUuid()));
        }
        model.addAttribute("item", (Object)item);
        List existingLanguages = this.getExistingLanguagesFromIdentifiable((Identifiable)item);
        String dataLanguage = this.getDataLanguage(targetDataLanguage, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        Locale displayLocale = LocaleContextHolder.getLocale();
        List existingDigitalObjectsLanguages = this.languageService.sortLanguages(displayLocale, (Collection)((CudamiItemsClient)this.service).getLanguagesOfDigitalObjects(uuid));
        model.addAttribute("existingDigitalObjectsLanguages", (Object)existingDigitalObjectsLanguages).addAttribute("dataLanguageDigitalObjects", (Object)this.getDataLanguage(null, this.languageService));
        return "items/view";
    }
}

