/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.work;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.work.CudamiManifestationsClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.manifestation.Manifestation;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class ManifestationsController
extends AbstractEntitiesController<Manifestation, CudamiManifestationsClient> {
    public ManifestationsController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forManifestations(), languageService);
    }

    @GetMapping(value={"/manifestations"})
    public String list(Model model) throws TechnicalException {
        model.addAttribute("existingLanguages", (Object)this.getExistingLanguagesFromService());
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "manifestations/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "manifestations";
    }

    @GetMapping(value={"/manifestations/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        Manifestation manifestation = (Manifestation)this.service.getByUuid(uuid);
        if (manifestation == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("manifestation", (Object)manifestation);
        List existingLanguages = this.getExistingLanguagesFromIdentifiable((Identifiable)manifestation);
        String dataLanguage = this.getDataLanguage(targetDataLanguage, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        Locale displayLocale = LocaleContextHolder.getLocale();
        List existingItemsLanguages = this.languageService.sortLanguages(displayLocale, (Collection)((CudamiManifestationsClient)this.service).getLanguagesOfItems(uuid));
        model.addAttribute("existingItemsLanguages", (Object)existingItemsLanguages).addAttribute("dataLanguageItems", (Object)this.getDataLanguage(null, this.languageService));
        return "manifestations/view";
    }
}

