/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.resource;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.AbstractIdentifiablesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.resource.CudamiFileResourcesMetadataClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.resource.FileResource;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class FileResourcesMetadataController
extends AbstractIdentifiablesController<FileResource, CudamiFileResourcesMetadataClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FileResourcesMetadataController.class);

    public FileResourcesMetadataController(CudamiClient client, LanguageService languageService) {
        super((CudamiIdentifiablesClient)client.forFileResourcesMetadata(), languageService);
    }

    @GetMapping(value={"/fileresources/new"})
    public String create(Model model) throws TechnicalException {
        model.addAttribute("activeLanguage", (Object)this.languageService.getDefaultLanguage());
        return "fileresources/create";
    }

    @GetMapping(value={"/fileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException {
        Locale displayLocale = LocaleContextHolder.getLocale();
        FileResource fileResource = (FileResource)this.service.getByUuid(uuid);
        List existingLanguages = this.languageService.sortLanguages(displayLocale, (Collection)fileResource.getLabel().getLocales());
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        model.addAttribute("filename", (Object)fileResource.getFilename());
        model.addAttribute("uuid", (Object)fileResource.getUuid());
        return "fileresources/edit";
    }

    @GetMapping(value={"/fileresources"})
    public String list(Model model) throws TechnicalException {
        model.addAttribute("existingLanguages", (Object)this.getExistingLanguagesFromService());
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "fileresources/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "fileresources";
    }

    @GetMapping(value={"/fileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        FileResource resource = (FileResource)this.service.getByUuid(uuid);
        if (resource == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("fileresource", (Object)resource);
        List existingLanguages = this.getExistingLanguagesFromIdentifiable((Identifiable)resource);
        String dataLanguage = this.getDataLanguage(targetDataLanguage, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        return "fileresources/view";
    }
}

