/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.resource;

import de.digitalcollections.cudami.admin.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.AbstractIdentifiablesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.resource.CudamiImageFileResourcesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class ImageFileResourcesAPIController
extends AbstractIdentifiablesController<ImageFileResource, CudamiImageFileResourcesClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageFileResourcesAPIController.class);

    public ImageFileResourcesAPIController(CudamiClient client, LanguageService languageService) {
        super((CudamiIdentifiablesClient)client.forImageFileResources(), languageService);
    }

    @GetMapping(value={"/api/imagefileresources/new"})
    @ResponseBody
    public ImageFileResource create() throws TechnicalException {
        return (ImageFileResource)this.service.create();
    }

    @GetMapping(value={"/api/imagefileresources"})
    @ResponseBody
    public PageResponse<ImageFileResource> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="searchTerm", required=false) String searchTerm, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws TechnicalException, ServiceException {
        PageRequest pageRequest = new PageRequest(searchTerm, pageNumber, pageSize);
        if (sortBy != null) {
            Sorting sorting = new Sorting(sortBy);
            pageRequest.setSorting(sorting);
        }
        return this.service.find(pageRequest);
    }

    @GetMapping(value={"/api/imagefileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    @ResponseBody
    public ImageFileResource getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (ImageFileResource)this.service.getByUuid(uuid);
    }

    @PostMapping(value={"/api/imagefileresources"})
    public ResponseEntity save(@RequestBody ImageFileResource imageFileResource) {
        try {
            ImageFileResource fileResourceDb = (ImageFileResource)this.service.save((UniqueObject)imageFileResource);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)fileResourceDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save image fileresource: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/imagefileresources/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody ImageFileResource imageFileResource) {
        try {
            ImageFileResource fileResourceDb = (ImageFileResource)this.service.update(uuid, (UniqueObject)imageFileResource);
            return ResponseEntity.ok((Object)fileResourceDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save image fileresource with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

