/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.semantic;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.business.impl.validator.LabelNotBlankValidator;
import de.digitalcollections.cudami.admin.controller.identifiable.AbstractIdentifiablesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.config.CudamiConfigClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.entity.semantic.CudamiSubjectsClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.semantic.Subject;
import de.digitalcollections.model.text.LocalizedText;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"subject"})
public class SubjectsController
extends AbstractIdentifiablesController<Subject, CudamiSubjectsClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(SubjectsController.class);
    private final LabelNotBlankValidator labelNotBlankValidator;
    private final MessageSource messageSource;
    private CudamiConfigClient cudamiConfigClient;

    public SubjectsController(CudamiClient client, LanguageService languageService, MessageSource messageSource, LabelNotBlankValidator labelNotBlankValidator) {
        super((CudamiIdentifiablesClient)client.forSubjects(), languageService);
        this.cudamiConfigClient = client.forConfig();
        this.labelNotBlankValidator = labelNotBlankValidator;
        this.messageSource = messageSource;
    }

    @GetMapping(value={"/subjects/new"})
    public String create(Model model) throws TechnicalException {
        Subject subject = (Subject)this.service.create();
        Locale defaultLanguage = this.languageService.getDefaultLanguage();
        subject.setLabel(new LocalizedText(defaultLanguage, ""));
        model.addAttribute("subject", (Object)subject);
        List<Locale> existingLanguages = List.of(defaultLanguage);
        model.addAttribute("existingLanguages", existingLanguages);
        List sortedLanguages = this.languageService.getAllLanguages();
        model.addAttribute("allLanguages", (Object)sortedLanguages);
        model.addAttribute("activeLanguage", (Object)defaultLanguage);
        List subjectTypes = this.cudamiConfigClient.getConfig().getTypeDeclarations().getSubjectTypes();
        model.addAttribute("subjectTypes", (Object)subjectTypes);
        model.addAttribute("mode", (Object)"create");
        return "subjects/create-or-edit";
    }

    @GetMapping(value={"/subjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException {
        Subject subject = (Subject)this.service.getByUuid(uuid);
        model.addAttribute("subject", (Object)subject);
        List existingLanguages = this.languageService.getExistingLanguages(this.languageService.getDefaultLanguage(), subject.getLabel());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        List sortedLanguages = this.languageService.getAllLanguages();
        model.addAttribute("allLanguages", (Object)sortedLanguages);
        List subjectTypes = this.cudamiConfigClient.getConfig().getTypeDeclarations().getSubjectTypes();
        model.addAttribute("subjectTypes", (Object)subjectTypes);
        model.addAttribute("mode", (Object)"edit");
        return "subjects/create-or-edit";
    }

    @GetMapping(value={"/subjects"})
    public String list(Model model) throws TechnicalException {
        List existingLanguages = this.languageService.getExistingLanguagesForLocales(((CudamiSubjectsClient)this.service).getLanguages());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "subjects/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "subjects";
    }

    @PostMapping(value={"/subjects/new"})
    public String save(@ModelAttribute(value="formData") Subject subjectFormData, @ModelAttribute @Valid Subject subject, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws TechnicalException {
        model.addAttribute("mode", (Object)"create");
        this.verifyBinding(results);
        subject.setLabel(subjectFormData.getLabel());
        subject.setSubjectType(subjectFormData.getSubjectType());
        this.validate(subject, results);
        if (results.hasErrors()) {
            Locale defaultLanguage = this.languageService.getDefaultLanguage();
            model.addAttribute("existingLanguages", (Object)this.languageService.getExistingLanguages(defaultLanguage, subject.getLabel()));
            model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
            model.addAttribute("activeLanguage", (Object)defaultLanguage);
            List subjectTypes = this.cudamiConfigClient.getConfig().getTypeDeclarations().getSubjectTypes();
            model.addAttribute("subjectTypes", (Object)subjectTypes);
            return "subjects/create-or-edit";
        }
        Subject subjectDB = null;
        try {
            subjectDB = (Subject)this.service.save((UniqueObject)subject);
            LOGGER.info("Successfully saved subject");
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save subject: ", (Throwable)e);
            String message = this.messageSource.getMessage("error.technical_error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/subjects";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/subjects/" + subjectDB.getUuid().toString();
    }

    private void validate(Subject subject, BindingResult results) {
        this.labelNotBlankValidator.validate((Object)subject.getLabel(), (Errors)results);
    }

    @PostMapping(value={"/subjects/{pathUuid}/edit"})
    public String update(@PathVariable UUID pathUuid, @ModelAttribute(value="formData") Subject subjectFormData, @ModelAttribute Subject subject, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws TechnicalException {
        model.addAttribute("mode", (Object)"edit");
        this.verifyBinding(results);
        subject.setLabel(subjectFormData.getLabel());
        subject.setSubjectType(subjectFormData.getSubjectType());
        this.validate(subject, results);
        if (results.hasErrors()) {
            Locale defaultLanguage = this.languageService.getDefaultLanguage();
            model.addAttribute("existingLanguages", (Object)this.languageService.getExistingLanguages(defaultLanguage, subject.getLabel()));
            model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
            model.addAttribute("activeLanguage", (Object)defaultLanguage);
            List subjectTypes = this.cudamiConfigClient.getConfig().getTypeDeclarations().getSubjectTypes();
            model.addAttribute("subjectTypes", (Object)subjectTypes);
            return "subjects/create-or-edit";
        }
        try {
            this.service.update(pathUuid, (UniqueObject)subject);
        }
        catch (TechnicalException e) {
            String message = "Cannot update subject with uuid=" + pathUuid + ": " + e;
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/subjects/" + pathUuid + "/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/subjects/" + pathUuid;
    }

    @GetMapping(value={"/subjects/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        Subject subject = (Subject)this.service.getByUuid(uuid);
        if (subject == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("subject", (Object)subject);
        List existingLanguages = this.getExistingLanguagesFromIdentifiable((Identifiable)subject);
        String dataLanguage = this.getDataLanguage(targetDataLanguage, existingLanguages, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        return "subjects/view";
    }
}

