/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.work;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.work.CudamiWorksClient;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.entity.work.Work;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class WorksController
extends AbstractEntitiesController<Work, CudamiWorksClient> {
    public WorksController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forWorks(), client, languageService);
    }

    @GetMapping(value={"/works"})
    public String list(Model model) throws TechnicalException {
        model.addAttribute("existingLanguages", (Object)this.getExistingLanguagesFromService());
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "works/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "works";
    }

    @GetMapping(value={"/works/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        Work work = (Work)this.service.getByUuid(uuid);
        if (work == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("work", (Object)work);
        List existingLanguages = this.getExistingLanguagesFromIdentifiable((Identifiable)work);
        String dataLanguage = this.getDataLanguage(targetDataLanguage, existingLanguages, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        Locale displayLocale = LocaleContextHolder.getLocale();
        List existingManifestationsLanguages = this.languageService.sortLanguages(displayLocale, (Collection)((CudamiWorksClient)this.service).getLanguagesOfManifestations(uuid));
        String dataLanguageManifestations = this.getDataLanguage(targetDataLanguage, existingManifestationsLanguages, this.languageService);
        model.addAttribute("existingManifestationsLanguages", (Object)existingManifestationsLanguages).addAttribute("dataLanguageManifestations", (Object)dataLanguageManifestations);
        return "works/view";
    }
}

