/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.security;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.admin.business.api.service.security.UserService;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.security.Role;
import de.digitalcollections.model.security.User;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import javax.validation.Valid;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"user"})
public class UsersController
extends AbstractController {
    private final MessageSource messageSource;
    private final UserService<User> service;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public UsersController(UserService service, MessageSource messageSource) {
        this.messageSource = messageSource;
        this.service = service;
    }

    @GetMapping(value={"/users/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/activate"})
    public String activate(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) throws TechnicalException {
        boolean successful = this.service.setStatus(uuid, true);
        if (successful) {
            String message = this.messageSource.getMessage("msg.user_activated", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("success_message", (Object)message);
        } else {
            String message = this.messageSource.getMessage("error.technical_error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
        }
        return "redirect:/users";
    }

    @GetMapping(value={"/users/new"})
    public String create(Model model) throws ServiceException {
        model.addAttribute("mode", (Object)"create");
        model.addAttribute("user", (Object)this.service.create());
        return "users/create-or-edit";
    }

    @PostMapping(value={"/users/new"})
    public String create(@RequestParam(value="pwd1", required=false) String password1, @RequestParam(value="pwd2", required=false) String password2, @ModelAttribute(name="user") @Valid User user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws ServiceException {
        model.addAttribute("mode", (Object)"create");
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "users/create-or-edit";
        }
        User userDb = this.service.create(user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            return "users/create-or-edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/users/" + userDb.getUuid().toString();
    }

    @GetMapping(value={"/users/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/deactivate"})
    public String deactivate(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) throws TechnicalException {
        boolean successful = this.service.setStatus(uuid, false);
        if (successful) {
            String message = this.messageSource.getMessage("msg.user_deactivated", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("success_message", (Object)message);
        } else {
            String message = this.messageSource.getMessage("error.technical_error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
        }
        return "redirect:/users";
    }

    @GetMapping(value={"/users/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, Model model) throws ServiceException {
        model.addAttribute("mode", (Object)"edit");
        model.addAttribute("user", (Object)this.service.getByUuid(uuid));
        return "users/create-or-edit";
    }

    @PostMapping(value={"/users/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="pwd1", required=false) String password1, @RequestParam(name="pwd2", required=false) String password2, @ModelAttribute(name="user") @Valid User user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws ServiceException {
        model.addAttribute("mode", (Object)"edit");
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "users/create-or-edit";
        }
        this.service.update(user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            return "users/create-or-edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/users/" + uuid;
    }

    @GetMapping(value={"/users"})
    public String list() {
        return "users/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "users";
    }

    @ModelAttribute(value="allRoles")
    protected List<Role> populateAllRoles() {
        return Arrays.asList(Role.values());
    }

    @GetMapping(value={"/users/updatePassword"})
    public String updatePassword(Model model) throws ServiceException {
        User currentUser = this.service.getByEmail(SecurityContextHolder.getContext().getAuthentication().getName());
        model.addAttribute("user", (Object)currentUser);
        return "users/edit-password";
    }

    @PostMapping(value={"/users/updatePassword"})
    public String updatePassword(@RequestParam(value="pwd1") String password1, @RequestParam(value="pwd2") String password2, @ModelAttribute(name="user") @Valid User user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws ServiceException {
        this.verifyBinding(results);
        String errorMessage = this.messageSource.getMessage("error.password_change_failed", null, LocaleContextHolder.getLocale());
        if (results.hasErrors()) {
            model.addAttribute("error_message", (Object)errorMessage);
            return "users/edit-password";
        }
        this.service.update(user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            model.addAttribute("error_message", (Object)errorMessage);
            return "users/edit-password";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changed_password_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/";
    }

    @GetMapping(value={"/users/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, Model model) throws ResourceNotFoundException, ServiceException {
        User user = this.service.getByUuid(uuid);
        if (user == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("user", (Object)user);
        return "users/view";
    }
}

