/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.AbstractUniqueObjectController;
import de.digitalcollections.cudami.admin.controller.ParameterHelper;
import de.digitalcollections.cudami.admin.controller.identifiable.AbstractIdentifiablesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.IdentifiableObjectType;
import de.digitalcollections.model.identifiable.entity.HeadwordEntry;
import de.digitalcollections.model.list.ListRequest;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.tuple.Pair;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.ui.Model;
import org.springframework.util.CollectionUtils;

public class AbstractIdentifiablesController<I extends Identifiable, C extends CudamiIdentifiablesClient<I>>
extends AbstractUniqueObjectController<I> {
    private final CudamiClient cudamiClient;

    protected AbstractIdentifiablesController(C service, CudamiClient cudamiClient, LanguageService languageService) {
        super(service, languageService);
        this.cudamiClient = cudamiClient;
    }

    protected List<Locale> getExistingLanguagesFromIdentifiable(Identifiable identifiable) {
        return this.getExistingLanguagesFromIdentifiables(List.of(identifiable));
    }

    protected List<Locale> getExistingLanguagesFromIdentifiables(List<? extends Identifiable> identifiables) {
        List existingLanguages = Collections.emptyList();
        if (!CollectionUtils.isEmpty(identifiables)) {
            existingLanguages = identifiables.stream().flatMap(child -> child.getLabel() != null ? Stream.concat(child.getLabel().getLocales().stream(), child.getDescription() != null ? child.getDescription().keySet().stream() : Stream.of(new Locale[0])) : Stream.of(new Locale[0])).collect(Collectors.toList());
            existingLanguages = this.languageService.sortLanguages(LocaleContextHolder.getLocale(), existingLanguages);
        }
        return existingLanguages;
    }

    protected List<Locale> getExistingLanguagesFromService() throws TechnicalException {
        List serviceLocales = ((CudamiIdentifiablesClient)this.service).getLanguages();
        List existingLanguages = Collections.emptyList();
        if (!CollectionUtils.isEmpty((Collection)serviceLocales)) {
            existingLanguages = this.languageService.sortLanguages(LocaleContextHolder.getLocale(), (Collection)serviceLocales);
        }
        return existingLanguages;
    }

    protected PageResponse<I> search(String searchField, String searchTerm, PageRequest pageRequest) throws TechnicalException {
        if (searchField == null) {
            PageResponse pageResponse = this.service.find(pageRequest);
            return pageResponse;
        }
        switch (searchField) {
            case "label": {
                PageResponse pageResponse = this.service.find(pageRequest);
                return pageResponse;
            }
            case "uuid": {
                Identifiable identifiable = (Identifiable)this.service.getByUuid(UUID.fromString(searchTerm));
                PageResponse pageResponse = identifiable == null ? PageResponse.builder().withContent(new ArrayList()).build() : PageResponse.builder().withContent((Object)identifiable).build();
                pageResponse.setRequest((ListRequest)pageRequest);
                return pageResponse;
            }
            case "identifier": {
                Pair namespaceAndId = ParameterHelper.extractPairOfStrings((String)searchTerm);
                Identifiable identifiable = ((CudamiIdentifiablesClient)this.service).getByIdentifier((String)namespaceAndId.getLeft(), (String)namespaceAndId.getRight());
                PageResponse pageResponse = identifiable == null ? PageResponse.builder().withContent(new ArrayList()).build() : PageResponse.builder().withContent((Object)identifiable).build();
                pageResponse.setRequest((ListRequest)pageRequest);
                return pageResponse;
            }
        }
        return null;
    }

    public String doForward(Identifiable identifiable, Model model) throws TechnicalException {
        String uuid = identifiable.getUuid().toString();
        IdentifiableObjectType identifiableObjectType = identifiable.getIdentifiableObjectType();
        switch (1.$SwitchMap$de$digitalcollections$model$identifiable$IdentifiableObjectType[identifiableObjectType.ordinal()]) {
            case 1: {
                return "forward:/articles/" + uuid;
            }
            case 2: {
                return "forward:/collections/" + uuid;
            }
            case 3: {
                return "forward:/corporatebodies/" + uuid;
            }
            case 4: {
                return "forward:/digitalobjects/" + uuid;
            }
            case 5: {
                return "forward:/geolocations/" + uuid;
            }
            case 6: {
                HeadwordEntry headwordEntry = (HeadwordEntry)this.cudamiClient.forHeadwordEntries().getByUuid(identifiable.getUuid());
                UUID headwordUuid = headwordEntry.getHeadword().getUuid();
                return "redirect:/headwords/" + headwordUuid;
            }
            case 7: {
                return "forward:/items/" + uuid;
            }
            case 8: {
                return "forward:/manifestations/" + uuid;
            }
            case 9: {
                return "forward:/persons/" + uuid;
            }
            case 10: {
                return "forward:/topics/" + uuid;
            }
            case 11: {
                return "forward:/works/" + uuid;
            }
        }
        throw new TechnicalException("Unhandled object type " + identifiableObjectType);
    }
}

