/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity.agent;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.business.impl.validator.LabelNotBlankValidator;
import de.digitalcollections.cudami.admin.controller.identifiable.AbstractIdentifiablesController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.agent.CudamiFamilyNamesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.agent.FamilyName;
import de.digitalcollections.model.text.LocalizedText;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"familyName"})
public class FamilynamesController
extends AbstractIdentifiablesController<FamilyName, CudamiFamilyNamesClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(FamilynamesController.class);
    private final LabelNotBlankValidator labelNotBlankValidator;
    private final MessageSource messageSource;

    public FamilynamesController(CudamiClient client, LanguageService languageService, MessageSource messageSource, LabelNotBlankValidator labelNotBlankValidator) {
        super((CudamiIdentifiablesClient)client.forFamilyNames(), client, languageService);
        this.labelNotBlankValidator = labelNotBlankValidator;
        this.messageSource = messageSource;
    }

    @GetMapping(value={"/familynames/new"})
    public String create(Model model) throws TechnicalException {
        FamilyName familyName = (FamilyName)this.service.create();
        Locale defaultLanguage = this.languageService.getDefaultLanguage();
        familyName.setLabel(new LocalizedText(defaultLanguage, ""));
        model.addAttribute("familyName", (Object)familyName);
        List<Locale> existingLanguages = List.of(defaultLanguage);
        List sortedLanguages = this.languageService.getAllLanguages();
        model.addAttribute("existingLanguages", existingLanguages);
        model.addAttribute("allLanguages", (Object)sortedLanguages);
        model.addAttribute("activeLanguage", (Object)defaultLanguage);
        model.addAttribute("mode", (Object)"create");
        return "familynames/create-or-edit";
    }

    @GetMapping(value={"/familynames/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException {
        FamilyName familyName = (FamilyName)this.service.getByUuid(uuid);
        model.addAttribute("familyName", (Object)familyName);
        List existingLanguages = this.languageService.getExistingLanguages(this.languageService.getDefaultLanguage(), familyName.getLabel());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        List sortedLanguages = this.languageService.getAllLanguages();
        model.addAttribute("allLanguages", (Object)sortedLanguages);
        model.addAttribute("mode", (Object)"edit");
        return "familynames/create-or-edit";
    }

    @GetMapping(value={"/familynames"})
    public String list(Model model) throws TechnicalException {
        model.addAttribute("existingLanguages", (Object)this.getExistingLanguagesFromService());
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "familynames/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "familynames";
    }

    @PostMapping(value={"/familynames/new"})
    public String save(@ModelAttribute(value="formData") FamilyName familyNameFormData, @ModelAttribute @Valid FamilyName familyName, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws TechnicalException {
        model.addAttribute("mode", (Object)"create");
        this.verifyBinding(results);
        familyName.setLabel(familyNameFormData.getLabel());
        familyName.setDescription(familyNameFormData.getDescription());
        this.validate((Identifiable)familyName, results);
        if (results.hasErrors()) {
            Locale defaultLanguage = this.languageService.getDefaultLanguage();
            model.addAttribute("existingLanguages", (Object)this.languageService.getExistingLanguages(defaultLanguage, familyName.getLabel()));
            model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
            model.addAttribute("activeLanguage", (Object)defaultLanguage);
            return "familynames/create-or-edit";
        }
        FamilyName familyNameDB = null;
        try {
            familyNameDB = (FamilyName)this.service.save((UniqueObject)familyName);
            LOGGER.info("Successfully saved familyName");
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save familyName: ", (Throwable)e);
            String message = this.messageSource.getMessage("error.technical_error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/familynames";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/familynames/" + familyNameDB.getUuid().toString();
    }

    private void validate(Identifiable identifiable, BindingResult results) {
        this.labelNotBlankValidator.validate((Object)identifiable.getLabel(), (Errors)results);
    }

    @PostMapping(value={"/familynames/{pathUuid}/edit"})
    public String update(@PathVariable UUID pathUuid, @ModelAttribute(value="formData") FamilyName familyNameFormData, @ModelAttribute FamilyName familyName, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws TechnicalException {
        model.addAttribute("mode", (Object)"edit");
        this.verifyBinding(results);
        familyName.setLabel(familyNameFormData.getLabel());
        familyName.setDescription(familyNameFormData.getDescription());
        this.validate((Identifiable)familyName, results);
        if (results.hasErrors()) {
            Locale defaultLanguage = this.languageService.getDefaultLanguage();
            model.addAttribute("existingLanguages", (Object)this.languageService.getExistingLanguages(defaultLanguage, familyName.getLabel()));
            model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
            model.addAttribute("activeLanguage", (Object)defaultLanguage);
            return "familynames/create-or-edit";
        }
        try {
            this.service.update(pathUuid, (UniqueObject)familyName);
        }
        catch (TechnicalException e) {
            String message = "Cannot update familyName with uuid=" + pathUuid + ": " + e;
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/familynames/" + pathUuid + "/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/familynames/" + pathUuid;
    }

    @GetMapping(value={"/familynames/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        FamilyName familyName = (FamilyName)this.service.getByUuid(uuid);
        if (familyName == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("familyName", (Object)familyName);
        List existingLanguages = this.getExistingLanguagesFromIdentifiable((Identifiable)familyName);
        String dataLanguage = this.getDataLanguage(targetDataLanguage, existingLanguages, this.languageService);
        model.addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        return "familynames/view";
    }
}

