/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.business.impl.validator;

import de.digitalcollections.model.text.LocalizedText;
import java.util.Locale;
import java.util.Map;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.validation.Errors;
import org.springframework.validation.Validator;

@Component
public class LabelNotBlankValidator
implements Validator {
    public boolean supports(Class<?> clazz) {
        return LocalizedText.class.isAssignableFrom(clazz);
    }

    public void validate(Object target, Errors errors) {
        LocalizedText localizedText = (LocalizedText)target;
        if (localizedText == null || localizedText.isEmpty()) {
            errors.reject("label", "validation.label.NotBlank");
            return;
        }
        Locale displayLocale = LocaleContextHolder.getLocale();
        for (Map.Entry entry : localizedText.entrySet()) {
            Locale locale = (Locale)entry.getKey();
            String text = (String)entry.getValue();
            if (text != null && !text.isBlank()) continue;
            errors.reject("validation.label.language.NotBlank", (Object[])new String[]{locale.getDisplayLanguage(displayLocale)}, "validation.label.NotBlank");
            errors.rejectValue("label['" + locale.getLanguage() + "']", "javax.validation.constraints.NotBlank.message");
        }
    }
}

