/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller;

import de.digitalcollections.commons.springmvc.controller.AbstractController;
import de.digitalcollections.cudami.admin.business.api.service.exceptions.ServiceException;
import de.digitalcollections.cudami.admin.business.api.service.security.UserService;
import de.digitalcollections.model.security.User;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.validation.Valid;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"user"})
@SuppressFBWarnings
public class SetupController
extends AbstractController {
    private final MessageSource messageSource;
    private final UserService userService;

    public SetupController(MessageSource messageSource, UserService userService) {
        this.messageSource = messageSource;
        this.userService = userService;
    }

    @ModelAttribute(value="createAdmin")
    public boolean adminFlag() {
        return true;
    }

    @GetMapping(value={"/setup/adminUser"})
    public String adminUser(Model model) throws ServiceException {
        model.addAttribute("mode", (Object)"create");
        model.addAttribute("user", (Object)this.userService.createAdminUser());
        return "users/create-or-edit";
    }

    @PostMapping(value={"/setup/adminUser"})
    public String adminUser(@RequestParam(value="pwd1") String password1, @RequestParam(value="pwd2") String password2, @ModelAttribute(name="user") @Valid User user, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws ServiceException {
        model.addAttribute("mode", (Object)"create");
        this.verifyBinding(results);
        if (results.hasErrors()) {
            return "users/create-or-edit";
        }
        this.userService.create(user, password1, password2, (Errors)results);
        if (results.hasErrors()) {
            return "users/create-or-edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/";
    }
}

