/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.entity;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.entity.AbstractEntitiesController;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTRequest;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTResponse;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiCollectionsClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Order;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.actuate.endpoint.InvalidEndpointRequestException;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class CollectionsAPIController
extends AbstractEntitiesController<Collection, CudamiCollectionsClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CollectionsAPIController.class);

    public CollectionsAPIController(CudamiClient client, LanguageService languageService) {
        super((CudamiEntitiesClient)client.forCollections(), client, languageService);
    }

    @PostMapping(value={"/api/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects"})
    public ResponseEntity addDigitalObjects(@PathVariable UUID uuid, @RequestBody List<DigitalObject> digitalObjects) throws TechnicalException {
        boolean successful = ((CudamiCollectionsClient)this.service).addDigitalObjects(uuid, digitalObjects);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/collections/{collectionUuid}/collections/{subcollectionUuid}"})
    public ResponseEntity addSubcollection(@PathVariable UUID collectionUuid, @PathVariable UUID subcollectionUuid) throws TechnicalException {
        boolean successful = ((CudamiCollectionsClient)this.service).addSubcollection(collectionUuid, subcollectionUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/collections/{collectionUuid}/collections"})
    public ResponseEntity addSubcollections(@PathVariable UUID collectionUuid, @RequestBody List<Collection> subcollections) throws TechnicalException {
        boolean successful = ((CudamiCollectionsClient)this.service).addSubcollections(collectionUuid, subcollections);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @GetMapping(value={"/api/collections/new"})
    @ResponseBody
    public Collection create() throws TechnicalException {
        return (Collection)this.service.create();
    }

    @GetMapping(value={"/api/collections/search"})
    @ResponseBody
    public PageResponse<Collection> find(@RequestParam(name="pageNumber", required=false, defaultValue="0") int pageNumber, @RequestParam(name="pageSize", required=false, defaultValue="5") int pageSize, @RequestParam(name="searchField", required=false) String searchField, @RequestParam(name="searchTerm", required=false) String searchTerm, @RequestParam(name="sortBy", required=false) List<Order> sortBy) throws TechnicalException {
        String dataLanguage = null;
        PageRequest pageRequest = this.createPageRequest(Collection.class, pageNumber, pageSize, sortBy, searchField, searchTerm, dataLanguage);
        PageResponse pageResponse = this.search(searchField, searchTerm, pageRequest);
        if (pageResponse == null) {
            throw new InvalidEndpointRequestException("invalid request param", searchField);
        }
        return pageResponse;
    }

    @GetMapping(value={"/api/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/digitalobjects"})
    @ResponseBody
    public BTResponse<DigitalObject> findDigitalObjects(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(DigitalObject.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiCollectionsClient)this.service).findDigitalObjects(uuid, (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/collections"})
    @ResponseBody
    public BTResponse<Collection> findSubcollections(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(Collection.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiCollectionsClient)this.service).findSubcollections(uuid, (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/collections"})
    @ResponseBody
    @SuppressFBWarnings
    public BTResponse<Collection> findTop(@RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false, defaultValue="label") String sortProperty, @RequestParam(name="order", required=false, defaultValue="asc") String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(Collection.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiCollectionsClient)this.service).findTopCollections((PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/collections/identifier/{namespace}:{id}"})
    @ResponseBody
    public Collection getByIdentifier(@PathVariable String namespace, @PathVariable String id) throws TechnicalException {
        return (Collection)((CudamiIdentifiablesClient)this.service).getByIdentifier(namespace, id);
    }

    @GetMapping(value={"/api/collections/{refId:[0-9]+}"})
    @ResponseBody
    public Collection getByRefId(@PathVariable long refId) throws TechnicalException {
        return (Collection)((CudamiEntitiesClient)this.service).getByRefId(refId);
    }

    @GetMapping(value={"/api/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    @ResponseBody
    public Collection getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (Collection)this.service.getByUuid(uuid);
    }

    @DeleteMapping(value={"/api/collections/{collectionUuid}/digitalobjects/{digitalobjectUuid}"})
    @ResponseBody
    public ResponseEntity removeDigitalObject(@PathVariable UUID collectionUuid, @PathVariable UUID digitalobjectUuid) throws TechnicalException {
        boolean successful = ((CudamiCollectionsClient)this.service).removeDigitalObject(collectionUuid, digitalobjectUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @DeleteMapping(value={"/api/collections/{collectionUuid}/collections/{subcollectionUuid}"})
    public ResponseEntity removeSubcollection(@PathVariable UUID collectionUuid, @PathVariable UUID subcollectionUuid) throws TechnicalException {
        boolean successful = ((CudamiCollectionsClient)this.service).removeSubcollection(collectionUuid, subcollectionUuid);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }

    @PostMapping(value={"/api/collections"})
    public ResponseEntity save(@RequestBody Collection collection, @RequestParam(name="parentType", required=false) String parentType, @RequestParam(name="parentUuid", required=false) UUID parentUuid) {
        try {
            Collection collectionDb = null;
            collectionDb = "collection".equals(parentType) ? ((CudamiCollectionsClient)this.service).saveWithParentCollection(collection, parentUuid) : (Collection)this.service.save((UniqueObject)collection);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)collectionDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save collection: ", (Throwable)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/collections/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Collection collection) {
        try {
            Collection collectionDb = (Collection)this.service.update(uuid, (UniqueObject)collection);
            return ResponseEntity.ok((Object)collectionDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save collection with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }
}

