/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.relation;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.business.impl.validator.LabelNotBlankValidator;
import de.digitalcollections.cudami.admin.controller.AbstractUniqueObjectController;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.CudamiRestClient;
import de.digitalcollections.cudami.client.relation.CudamiPredicatesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.ResourceNotFoundException;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.relation.Predicate;
import de.digitalcollections.model.text.LocalizedText;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.validation.Errors;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.SessionAttributes;
import org.springframework.web.bind.support.SessionStatus;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@SessionAttributes(value={"predicate"})
public class PredicatesController
extends AbstractUniqueObjectController<Predicate> {
    private static final Logger LOGGER = LoggerFactory.getLogger(PredicatesController.class);
    private final LabelNotBlankValidator labelNotBlankValidator;
    private final MessageSource messageSource;

    public PredicatesController(CudamiClient client, LanguageService languageService, MessageSource messageSource, LabelNotBlankValidator labelNotBlankValidator) {
        super((CudamiRestClient)client.forPredicates(), languageService);
        this.labelNotBlankValidator = labelNotBlankValidator;
        this.messageSource = messageSource;
    }

    @GetMapping(value={"/predicates/new"})
    public String create(Model model) throws TechnicalException {
        Predicate predicate = (Predicate)this.service.create();
        Locale defaultLanguage = this.languageService.getDefaultLanguage();
        predicate.setLabel(new LocalizedText(defaultLanguage, ""));
        model.addAttribute("predicate", (Object)predicate);
        List<Locale> existingLanguages = List.of(defaultLanguage);
        List sortedLanguages = this.languageService.getAllLanguages();
        model.addAttribute("existingLanguages", existingLanguages);
        model.addAttribute("allLanguages", (Object)sortedLanguages);
        model.addAttribute("activeLanguage", (Object)defaultLanguage);
        model.addAttribute("mode", (Object)"create");
        return "predicates/create-or-edit";
    }

    @GetMapping(value={"/predicates/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/delete"})
    public String delete(@PathVariable UUID uuid, Model model, RedirectAttributes redirectAttributes) throws TechnicalException {
        this.service.deleteByUuid(uuid);
        String message = this.messageSource.getMessage("msg.deleted_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/predicates";
    }

    @GetMapping(value={"/predicates/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String edit(@PathVariable UUID uuid, @RequestParam(name="activeLanguage", required=false) Locale activeLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        Predicate predicate = (Predicate)this.service.getByUuid(uuid);
        if (predicate == null) {
            throw new ResourceNotFoundException();
        }
        model.addAttribute("predicate", (Object)predicate);
        List existingLanguages = this.languageService.getExistingLanguages(this.languageService.getDefaultLanguage(), predicate.getLabel());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        if (activeLanguage != null && existingLanguages.contains(activeLanguage)) {
            model.addAttribute("activeLanguage", (Object)activeLanguage);
        } else {
            model.addAttribute("activeLanguage", existingLanguages.get(0));
        }
        List sortedLanguages = this.languageService.getAllLanguages();
        model.addAttribute("allLanguages", (Object)sortedLanguages);
        model.addAttribute("mode", (Object)"edit");
        return "predicates/create-or-edit";
    }

    @GetMapping(value={"/predicates"})
    public String list(Model model) throws TechnicalException {
        List existingLanguages = this.languageService.getExistingLanguagesForLocales(((CudamiPredicatesClient)this.service).getLanguages());
        model.addAttribute("existingLanguages", (Object)existingLanguages);
        String dataLanguage = this.getDataLanguage(null, this.languageService);
        model.addAttribute("dataLanguage", (Object)dataLanguage);
        return "predicates/list";
    }

    @ModelAttribute(value="menu")
    protected String module() {
        return "predicates";
    }

    @PostMapping(value={"/predicates/new"})
    public String save(@ModelAttribute(value="formData") Predicate predicateFormData, @ModelAttribute @Valid Predicate predicate, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws TechnicalException {
        model.addAttribute("mode", (Object)"create");
        this.verifyBinding(results);
        predicate.setLabel(predicateFormData.getLabel());
        predicate.setDescription(predicateFormData.getDescription());
        this.validate(predicate, results);
        if (results.hasErrors()) {
            Locale defaultLanguage = this.languageService.getDefaultLanguage();
            model.addAttribute("existingLanguages", (Object)this.languageService.getExistingLanguages(defaultLanguage, predicate.getLabel()));
            model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
            model.addAttribute("activeLanguage", (Object)defaultLanguage);
            return "predicates/create-or-edit";
        }
        Predicate predicateDB = null;
        try {
            predicateDB = (Predicate)this.service.save((UniqueObject)predicate);
            LOGGER.info("Successfully saved predicate");
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save predicate: ", (Throwable)e);
            String message = this.messageSource.getMessage("error.technical_error", null, LocaleContextHolder.getLocale());
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/predicates";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.created_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/predicates/" + predicateDB.getUuid().toString();
    }

    @PostMapping(value={"/predicates/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/edit"})
    public String update(@PathVariable UUID uuid, @ModelAttribute(value="formData") Predicate predicateFormData, @ModelAttribute Predicate predicate, BindingResult results, Model model, SessionStatus status, RedirectAttributes redirectAttributes) throws TechnicalException {
        model.addAttribute("mode", (Object)"edit");
        this.verifyBinding(results);
        predicate.setLabel(predicateFormData.getLabel());
        predicate.setDescription(predicateFormData.getDescription());
        this.validate(predicate, results);
        if (results.hasErrors()) {
            Locale defaultLanguage = this.languageService.getDefaultLanguage();
            model.addAttribute("existingLanguages", (Object)this.languageService.getExistingLanguages(defaultLanguage, predicate.getLabel()));
            model.addAttribute("allLanguages", (Object)this.languageService.getAllLanguages());
            model.addAttribute("activeLanguage", (Object)defaultLanguage);
            return "predicates/create-or-edit";
        }
        try {
            this.service.update(uuid, (UniqueObject)predicate);
        }
        catch (TechnicalException e) {
            String message = "Cannot update predicate with uuid=" + uuid + ": " + e;
            LOGGER.error(message, (Throwable)e);
            redirectAttributes.addFlashAttribute("error_message", (Object)message);
            return "redirect:/predicates/" + uuid + "/edit";
        }
        status.setComplete();
        String message = this.messageSource.getMessage("msg.changes_saved_successfully", null, LocaleContextHolder.getLocale());
        redirectAttributes.addFlashAttribute("success_message", (Object)message);
        return "redirect:/predicates/" + uuid;
    }

    private void validate(Predicate predicate, BindingResult results) {
        this.labelNotBlankValidator.validate((Object)predicate.getLabel(), (Errors)results);
    }

    @GetMapping(value={"/predicates/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public String view(@PathVariable UUID uuid, @RequestParam(name="dataLanguage", required=false) String targetDataLanguage, Model model) throws TechnicalException, ResourceNotFoundException {
        Predicate predicate = (Predicate)this.service.getByUuid(uuid);
        if (predicate == null) {
            throw new ResourceNotFoundException();
        }
        List existingLanguages = predicate.getLabel() != null ? this.languageService.getExistingLanguagesForLocales(predicate.getLabel().getLocales()) : List.of();
        String dataLanguage = this.getDataLanguage(targetDataLanguage, existingLanguages, this.languageService);
        model.addAttribute("predicate", (Object)predicate).addAttribute("existingLanguages", (Object)existingLanguages).addAttribute("dataLanguage", (Object)dataLanguage);
        return "predicates/view";
    }
}

