/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.admin.controller.identifiable.web;

import de.digitalcollections.cudami.admin.business.i18n.LanguageService;
import de.digitalcollections.cudami.admin.controller.identifiable.AbstractIdentifiablesController;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTRequest;
import de.digitalcollections.cudami.admin.model.bootstraptable.BTResponse;
import de.digitalcollections.cudami.client.CudamiClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.web.CudamiWebpagesClient;
import de.digitalcollections.model.UniqueObject;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.util.List;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class WebpagesAPIController
extends AbstractIdentifiablesController<Webpage, CudamiWebpagesClient> {
    private static final Logger LOGGER = LoggerFactory.getLogger(WebpagesAPIController.class);

    public WebpagesAPIController(CudamiClient client, LanguageService languageService) {
        super((CudamiIdentifiablesClient)client.forWebpages(), client, languageService);
    }

    @GetMapping(value={"/api/webpages/new"})
    @ResponseBody
    public Webpage create() throws TechnicalException {
        return (Webpage)this.service.create();
    }

    @GetMapping(value={"/api/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/webpages"})
    @ResponseBody
    public BTResponse<Webpage> findSubpages(@PathVariable UUID uuid, @RequestParam(name="offset", required=false, defaultValue="0") int offset, @RequestParam(name="limit", required=false, defaultValue="10") int limit, @RequestParam(name="search", required=false) String searchTerm, @RequestParam(name="sort", required=false) String sortProperty, @RequestParam(name="order", required=false) String sortOrder, @RequestParam(name="dataLanguage", required=false) String dataLanguage) throws TechnicalException {
        BTRequest btRequest = this.createBTRequest(Webpage.class, offset, limit, sortProperty, sortOrder, "label", searchTerm, dataLanguage);
        PageResponse pageResponse = ((CudamiWebpagesClient)this.service).findSubpages(uuid, (PageRequest)btRequest);
        return new BTResponse(pageResponse);
    }

    @GetMapping(value={"/api/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    @ResponseBody
    public Webpage getByUuid(@PathVariable UUID uuid) throws TechnicalException {
        return (Webpage)this.service.getByUuid(uuid);
    }

    @PostMapping(value={"/api/webpages"})
    public ResponseEntity save(@RequestBody Webpage webpage, @RequestParam(value="parentType") String parentType, @RequestParam(value="parentUuid") UUID parentUuid) {
        try {
            Webpage webpageDb = null;
            webpageDb = parentType.equals("website") ? ((CudamiWebpagesClient)this.service).saveWithParentWebsite(webpage, parentUuid) : ((CudamiWebpagesClient)this.service).saveWithParentWebpage(webpage, parentUuid);
            return ResponseEntity.status((HttpStatus)HttpStatus.CREATED).body((Object)webpageDb);
        }
        catch (TechnicalException e) {
            if (parentType.equals("website")) {
                LOGGER.error("Cannot save top-level webpage: ", (Throwable)e);
            } else if (parentType.equals("webpage")) {
                LOGGER.error("Cannot save webpage: ", (Throwable)e);
            }
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}"})
    public ResponseEntity update(@PathVariable UUID uuid, @RequestBody Webpage webpage) {
        try {
            Webpage webpageDb = (Webpage)this.service.update(uuid, (UniqueObject)webpage);
            return ResponseEntity.ok((Object)webpageDb);
        }
        catch (TechnicalException e) {
            LOGGER.error("Cannot save webpage with uuid={}", (Object)uuid, (Object)e);
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body(null);
        }
    }

    @PutMapping(value={"/api/webpages/{uuid:^[0-9a-fA-F]{8}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{4}-[0-9a-fA-F]{12}$}/webpages"})
    public ResponseEntity updateSubpagesOrder(@PathVariable UUID uuid, @RequestBody List<Webpage> subpages) throws TechnicalException {
        boolean successful = ((CudamiWebpagesClient)this.service).updateChildrenOrder(uuid, subpages);
        if (successful) {
            return new ResponseEntity((Object)successful, HttpStatus.OK);
        }
        return new ResponseEntity((Object)successful, HttpStatus.NOT_FOUND);
    }
}

