/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.feign;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.feign.Environment;
import de.digitalcollections.cudami.client.feign.api.Client;
import de.digitalcollections.cudami.client.feign.api.CudamiClient;
import de.digitalcollections.cudami.client.feign.config.BackendUrls;
import de.digitalcollections.cudami.client.feign.config.BackendUrlsFromConfig;
import de.digitalcollections.cudami.client.feign.exceptions.CudamiRestErrorDecoder;
import de.digitalcollections.cudami.client.feign.impl.ClientFactory;
import de.digitalcollections.cudami.model.jackson.CudamiModule;
import de.digitalcollections.prosemirror.model.jackson.ProseMirrorModule;
import feign.Feign;
import feign.Logger;
import feign.ReflectiveFeign;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.lang.invoke.MethodHandles;
import java.net.URI;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Cudami {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final ClientFactory clientFactory;
    private final ConcurrentMap<Class, Client> clients;

    public Cudami(Environment environment) {
        this(new BackendUrlsFromConfig(environment));
    }

    public Cudami(URI uri) {
        this(uri.toString());
    }

    public Cudami(final String url) {
        this(new BackendUrls(){

            @Override
            public String forBackend(String backend) {
                return url;
            }
        });
    }

    public Cudami(BackendUrls backendUrls) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.registerModule((Module)new CudamiModule());
        mapper.registerModule((Module)new ProseMirrorModule());
        Feign.Builder feign = ReflectiveFeign.builder().decoder((Decoder)new JacksonDecoder(mapper)).encoder((Encoder)new JacksonEncoder(mapper)).errorDecoder((ErrorDecoder)new CudamiRestErrorDecoder()).logger((feign.Logger)new Slf4jLogger()).logLevel(Logger.Level.BASIC).retryer((Retryer)new Retryer.Default());
        this.clientFactory = new ClientFactory(feign, backendUrls);
        this.clients = new ConcurrentHashMap<Class, Client>();
    }

    public CudamiClient cudamiClient() {
        return (CudamiClient)this.clients.computeIfAbsent(CudamiClient.class, __ -> this.clientFactory.createCudamiClient());
    }
}

