/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.feign.config;

import de.digitalcollections.cudami.client.feign.Environment;
import de.digitalcollections.cudami.client.feign.config.BackendUrls;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.yaml.snakeyaml.Yaml;

public class BackendUrlsFromConfig
implements BackendUrls {
    private static final String BACKENDS = "/cudami-backends.yml";
    private final Map<String, Map<String, String>> backendMapping;
    private static final Logger LOGGER = LoggerFactory.getLogger(BackendUrlsFromConfig.class);
    private final Environment environment;

    public BackendUrlsFromConfig(Environment environment) {
        this.environment = environment;
        this.backendMapping = this.loadBackendMapping();
    }

    @Override
    public String forBackend(String backend) {
        Map<String, String> urls = this.backendMapping.get(this.environment.name().toLowerCase());
        if (urls == null) {
            throw new IllegalStateException("No mapping for environment " + (Object)((Object)this.environment) + " found.");
        }
        return urls.getOrDefault(backend, urls.get("default"));
    }

    private Map<String, Map<String, String>> loadBackendMapping() {
        LOGGER.info("Loading Cudami backend urls for environment " + (Object)((Object)this.environment) + ".");
        Yaml yaml = new Yaml();
        Map result = null;
        try (InputStream in = BackendUrlsFromConfig.class.getResourceAsStream(BACKENDS);){
            result = (Map)yaml.load(in);
        }
        catch (IOException exception) {
            throw new IllegalStateException(exception);
        }
        if (result == null) {
            throw new IllegalStateException("Could not load backend mapping for '/cudami-backends.yml'");
        }
        return result;
    }
}

