/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.feign.exceptions;

import feign.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class HttpException
extends Exception {
    int statuscode;
    String errorMessage;

    public HttpException(String methodKey, Response response) {
        super(String.format("Got %d for backend call %s.%n\u2937 %s", response.status(), methodKey, response.request()));
        if (response.body() != null) {
            try (InputStreamReader ir = new InputStreamReader(response.body().asInputStream());){
                this.errorMessage = ((Stream)new BufferedReader(ir).lines().parallel()).collect(Collectors.joining(" "));
                this.errorMessage = this.errorMessage.replaceFirst("^\"", "").replaceFirst("\"$", "");
            }
            catch (IOException e) {
                this.errorMessage = "Cannot read error message because of " + e.getMessage();
            }
        }
        this.statuscode = response.status();
    }

    public int getStatusCode() {
        return this.statuscode;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }
}

