/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.exceptions.CudamiRestErrorDecoder;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Project;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.ProjectImpl;
import de.digitalcollections.model.impl.paging.FindParamsImpl;
import de.digitalcollections.model.jackson.DigitalCollectionsObjectMapper;
import feign.Headers;
import feign.Logger;
import feign.Param;
import feign.ReflectiveFeign;
import feign.RequestLine;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.util.UUID;

public interface CudamiProjectsClient {
    public static CudamiProjectsClient build(String serverUrl) {
        DigitalCollectionsObjectMapper mapper = new DigitalCollectionsObjectMapper();
        CudamiProjectsClient backend = (CudamiProjectsClient)ReflectiveFeign.builder().decoder((Decoder)new JacksonDecoder((ObjectMapper)mapper)).encoder((Encoder)new JacksonEncoder((ObjectMapper)mapper)).errorDecoder((ErrorDecoder)new CudamiRestErrorDecoder()).logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.BASIC).retryer((Retryer)new Retryer.Default()).target(CudamiProjectsClient.class, serverUrl);
        return backend;
    }

    default public Project createProject() {
        return new ProjectImpl();
    }

    default public PageResponse findProjects(PageRequest pageRequest) {
        FindParamsImpl f = new FindParamsImpl(pageRequest);
        PageResponse<Project> pageResponse = this.findProjects(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return pageResponse;
    }

    @RequestLine(value="GET /latest/projects?pageNumber={pageNumber}&pageSize={pageSize}&sortField={sortField}&sortDirection={sortDirection}&nullHandling={nullHandling}")
    public PageResponse<Project> findProjects(@Param(value="pageNumber") int var1, @Param(value="pageSize") int var2, @Param(value="sortField") String var3, @Param(value="sortDirection") String var4, @Param(value="nullHandling") String var5);

    @RequestLine(value="GET /latest/projects/{uuid}")
    public Project getProject(@Param(value="uuid") UUID var1) throws HttpException;

    @RequestLine(value="POST /latest/projects/{parentProjectUuid}/project")
    @Headers(value={"Content-Type: application/json"})
    public Project saveProjectWithParentProject(Project var1, @Param(value="parentProjectUuid") UUID var2);

    @RequestLine(value="POST /latest/projects")
    @Headers(value={"Content-Type: application/json"})
    public Project saveProject(Project var1);

    default public Project updateProject(Project project) {
        return this.updateProject(project.getUuid(), project);
    }

    @RequestLine(value="PUT /latest/projects/{uuid}")
    @Headers(value={"Content-Type: application/json"})
    public Project updateProject(@Param(value="uuid") UUID var1, Project var2);
}

