/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.exceptions.CudamiRestErrorDecoder;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.jackson.DigitalCollectionsObjectMapper;
import feign.Logger;
import feign.Param;
import feign.ReflectiveFeign;
import feign.RequestLine;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.util.List;
import java.util.Locale;

public interface CudamiClient {
    public static CudamiClient build(String serverUrl) {
        DigitalCollectionsObjectMapper mapper = new DigitalCollectionsObjectMapper();
        CudamiClient client = (CudamiClient)ReflectiveFeign.builder().decoder((Decoder)new JacksonDecoder((ObjectMapper)mapper)).encoder((Encoder)new JacksonEncoder((ObjectMapper)mapper)).errorDecoder((ErrorDecoder)new CudamiRestErrorDecoder()).logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.BASIC).retryer((Retryer)new Retryer.Default()).target(CudamiClient.class, serverUrl);
        return client;
    }

    @RequestLine(value="GET /v2/languages/default")
    public String getDefaultLanguage() throws HttpException;

    @RequestLine(value="GET /v2/locales/default")
    public Locale getDefaultLocale() throws HttpException;

    @RequestLine(value="GET /v2/languages")
    public List<String> getSupportedLanguages() throws HttpException;

    @RequestLine(value="GET /v2/locales")
    public List<Locale> getSupportedLocales() throws HttpException;

    @RequestLine(value="GET /v3/webpages/{uuid}")
    public Webpage getWebpage(@Param(value="uuid") String var1) throws HttpException;

    @RequestLine(value="GET /v3/webpages/{uuid}?pLocale={locale}")
    public Webpage getWebpage(@Param(value="locale") Locale var1, @Param(value="uuid") String var2) throws HttpException;

    @RequestLine(value="GET /V2/websites/{uuid}")
    public Website getWebsite(@Param(value="uuid") String var1) throws HttpException;
}

