/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.exceptions.CudamiRestErrorDecoder;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Collection;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.CollectionImpl;
import de.digitalcollections.model.impl.paging.FindParamsImpl;
import de.digitalcollections.model.jackson.DigitalCollectionsObjectMapper;
import feign.Headers;
import feign.Logger;
import feign.Param;
import feign.ReflectiveFeign;
import feign.RequestLine;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.util.UUID;

public interface CudamiCollectionsClient {
    public static CudamiCollectionsClient build(String serverUrl) {
        DigitalCollectionsObjectMapper mapper = new DigitalCollectionsObjectMapper();
        CudamiCollectionsClient backend = (CudamiCollectionsClient)ReflectiveFeign.builder().decoder((Decoder)new JacksonDecoder((ObjectMapper)mapper)).encoder((Encoder)new JacksonEncoder((ObjectMapper)mapper)).errorDecoder((ErrorDecoder)new CudamiRestErrorDecoder()).logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.BASIC).retryer((Retryer)new Retryer.Default()).target(CudamiCollectionsClient.class, serverUrl);
        return backend;
    }

    default public Collection createCollection() {
        return new CollectionImpl();
    }

    default public PageResponse findCollections(PageRequest pageRequest) {
        FindParamsImpl f = new FindParamsImpl(pageRequest);
        PageResponse<Collection> pageResponse = this.findCollections(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return pageResponse;
    }

    @RequestLine(value="GET /latest/collections?pageNumber={pageNumber}&pageSize={pageSize}&sortField={sortField}&sortDirection={sortDirection}&nullHandling={nullHandling}")
    public PageResponse<Collection> findCollections(@Param(value="pageNumber") int var1, @Param(value="pageSize") int var2, @Param(value="sortField") String var3, @Param(value="sortDirection") String var4, @Param(value="nullHandling") String var5);

    @RequestLine(value="GET /latest/collections/{uuid}")
    public Collection getCollection(@Param(value="uuid") UUID var1) throws HttpException;

    @RequestLine(value="POST /latest/collections/{parentCollectionUuid}/collection")
    @Headers(value={"Content-Type: application/json"})
    public Collection saveCollectionWithParentCollection(Collection var1, @Param(value="parentCollectionUuid") UUID var2);

    @RequestLine(value="POST /latest/collections")
    @Headers(value={"Content-Type: application/json"})
    public Collection saveCollection(Collection var1);

    default public Collection updateCollection(Collection collection) {
        return this.updateCollection(collection.getUuid(), collection);
    }

    @RequestLine(value="PUT /latest/collections/{uuid}")
    @Headers(value={"Content-Type: application/json"})
    public Collection updateCollection(@Param(value="uuid") UUID var1, Collection var2);
}

