/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.exceptions.CudamiRestErrorDecoder;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Corporation;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.impl.identifiable.entity.CorporationImpl;
import de.digitalcollections.model.impl.paging.FindParamsImpl;
import de.digitalcollections.model.jackson.DigitalCollectionsObjectMapper;
import feign.Headers;
import feign.Logger;
import feign.Param;
import feign.ReflectiveFeign;
import feign.RequestLine;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.util.UUID;

public interface CudamiCorporationsClient {
    public static CudamiCorporationsClient build(String serverUrl) {
        DigitalCollectionsObjectMapper mapper = new DigitalCollectionsObjectMapper();
        CudamiCorporationsClient backend = (CudamiCorporationsClient)ReflectiveFeign.builder().decoder((Decoder)new JacksonDecoder((ObjectMapper)mapper)).encoder((Encoder)new JacksonEncoder((ObjectMapper)mapper)).errorDecoder((ErrorDecoder)new CudamiRestErrorDecoder()).logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.BASIC).retryer((Retryer)new Retryer.Default()).target(CudamiCorporationsClient.class, serverUrl);
        return backend;
    }

    default public Corporation createCorporation() {
        return new CorporationImpl();
    }

    default public PageResponse findCorporations(PageRequest pageRequest) {
        FindParamsImpl f = new FindParamsImpl(pageRequest);
        PageResponse<Corporation> pageResponse = this.findCorporations(f.getPageNumber(), f.getPageSize(), f.getSortField(), f.getSortDirection(), f.getNullHandling());
        return pageResponse;
    }

    @RequestLine(value="GET /latest/corporations?pageNumber={pageNumber}&pageSize={pageSize}&sortField={sortField}&sortDirection={sortDirection}&nullHandling={nullHandling}")
    public PageResponse<Corporation> findCorporations(@Param(value="pageNumber") int var1, @Param(value="pageSize") int var2, @Param(value="sortField") String var3, @Param(value="sortDirection") String var4, @Param(value="nullHandling") String var5);

    @RequestLine(value="GET /latest/corporations/{uuid}")
    public Corporation getCorporation(@Param(value="uuid") UUID var1) throws HttpException;

    @RequestLine(value="POST /latest/corporations/{parentCorporationUuid}/corporation")
    @Headers(value={"Content-Type: application/json"})
    public Corporation saveCorporationWithParentCorporation(Corporation var1, @Param(value="parentCorporationUuid") UUID var2);

    @RequestLine(value="POST /latest/corporations")
    @Headers(value={"Content-Type: application/json"})
    public Corporation saveCorporation(Corporation var1);

    default public Corporation updateCorporation(Corporation corporation) {
        return this.updateCorporation(corporation.getUuid(), corporation);
    }

    @RequestLine(value="PUT /latest/corporations/{uuid}")
    @Headers(value={"Content-Type: application/json"})
    public Corporation updateCorporation(@Param(value="uuid") UUID var1, Corporation var2);
}

