/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.exceptions.CudamiRestErrorDecoder;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Website;
import de.digitalcollections.model.api.identifiable.entity.parts.Webpage;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.jackson.DigitalCollectionsObjectMapper;
import feign.Logger;
import feign.Param;
import feign.QueryMap;
import feign.ReflectiveFeign;
import feign.RequestLine;
import feign.Retryer;
import feign.codec.Decoder;
import feign.codec.Encoder;
import feign.codec.ErrorDecoder;
import feign.jackson.JacksonDecoder;
import feign.jackson.JacksonEncoder;
import feign.slf4j.Slf4jLogger;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;

public interface CudamiWebpagesClient {
    public static CudamiWebpagesClient build(String serverUrl) {
        DigitalCollectionsObjectMapper mapper = new DigitalCollectionsObjectMapper();
        CudamiWebpagesClient backend = (CudamiWebpagesClient)ReflectiveFeign.builder().decoder((Decoder)new JacksonDecoder((ObjectMapper)mapper)).encoder((Encoder)new JacksonEncoder((ObjectMapper)mapper)).errorDecoder((ErrorDecoder)new CudamiRestErrorDecoder()).logger((Logger)new Slf4jLogger()).logLevel(Logger.Level.BASIC).retryer((Retryer)new Retryer.Default()).target(CudamiWebpagesClient.class, serverUrl);
        return backend;
    }

    @RequestLine(value="GET /v3/webpages/{uuid}")
    public Webpage getWebpage(@Param(value="uuid") String var1) throws HttpException;

    @RequestLine(value="GET /v3/webpages/{uuid}?pLocale={locale}")
    public Webpage getWebpage(@Param(value="locale") Locale var1, @Param(value="uuid") String var2) throws HttpException;

    @RequestLine(value="GET /v3/webpages/{uuid}/children")
    public PageResponse<Webpage> getChildren(@Param(value="uuid") UUID var1, @QueryMap Map var2);

    @RequestLine(value="GET /V2/websites/{uuid}")
    public Website getWebsite(@Param(value="uuid") String var1) throws HttpException;
}

