/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import de.digitalcollections.cudami.client.CudamiCollectionsClient;
import de.digitalcollections.cudami.client.CudamiCorporationsClient;
import de.digitalcollections.cudami.client.CudamiProjectsClient;
import de.digitalcollections.cudami.client.CudamiSystemClient;
import de.digitalcollections.cudami.client.CudamiWebpagesClient;

public class CudamiClient {
    private final CudamiCollectionsClient cudamiCollectionsClient;
    private final CudamiCorporationsClient cudamiCorporationsClient;
    private final CudamiProjectsClient cudamiProjectsClient;
    private final CudamiSystemClient cudamiSystemClient;
    private final CudamiWebpagesClient cudamiWebpagesClient;

    public CudamiClient(String cudamiServerUrl) {
        this.cudamiCollectionsClient = CudamiCollectionsClient.build(cudamiServerUrl);
        this.cudamiCorporationsClient = CudamiCorporationsClient.build(cudamiServerUrl);
        this.cudamiProjectsClient = CudamiProjectsClient.build(cudamiServerUrl);
        this.cudamiSystemClient = CudamiSystemClient.build(cudamiServerUrl);
        this.cudamiWebpagesClient = CudamiWebpagesClient.build(cudamiServerUrl);
    }

    public CudamiCollectionsClient forCollections() {
        return this.cudamiCollectionsClient;
    }

    public CudamiCorporationsClient forCorporations() {
        return this.cudamiCorporationsClient;
    }

    public CudamiProjectsClient forProjects() {
        return this.cudamiProjectsClient;
    }

    public CudamiSystemClient forSystem() {
        return this.cudamiSystemClient;
    }

    public CudamiWebpagesClient forWebpages() {
        return this.cudamiWebpagesClient;
    }
}

