/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiArticlesClient;
import de.digitalcollections.cudami.client.CudamiCollectionsClient;
import de.digitalcollections.cudami.client.CudamiDigitalObjectsClient;
import de.digitalcollections.cudami.client.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.CudamiEntityPartsClient;
import de.digitalcollections.cudami.client.CudamiEntityRelationsClient;
import de.digitalcollections.cudami.client.CudamiFileResourcesBinaryClient;
import de.digitalcollections.cudami.client.CudamiFileResourcesMetadataClient;
import de.digitalcollections.cudami.client.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.CudamiIdentifierTypesClient;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.CudamiPredicatesClient;
import de.digitalcollections.cudami.client.CudamiProjectsClient;
import de.digitalcollections.cudami.client.CudamiSubtopicsClient;
import de.digitalcollections.cudami.client.CudamiTopicsClient;
import de.digitalcollections.cudami.client.CudamiUsersClient;
import de.digitalcollections.cudami.client.CudamiWebpagesClient;
import de.digitalcollections.cudami.client.CudamiWebsitesClient;
import de.digitalcollections.cudami.client.entity.agent.CudamiCorporateBodiesClient;
import de.digitalcollections.cudami.client.entity.agent.CudamiPersonsClient;
import de.digitalcollections.cudami.client.entity.work.CudamiItemsClient;
import de.digitalcollections.cudami.client.entity.work.CudamiWorksClient;
import java.net.http.HttpClient;
import java.time.Duration;

public class CudamiClient {
    protected final HttpClient http;
    private final CudamiArticlesClient cudamiArticlesClient;
    private final CudamiCollectionsClient cudamiCollectionsClient;
    private final CudamiCorporateBodiesClient cudamiCorporateBodiesClient;
    private final CudamiDigitalObjectsClient cudamiDigitalObjectsClient;
    private final CudamiEntitiesClient cudamiEntitiesClient;
    private final CudamiEntityPartsClient cudamiEntityPartsClient;
    private final CudamiEntityRelationsClient cudamiEntityRelationsClient;
    private final CudamiFileResourcesBinaryClient cudamiFileResourcesBinaryClient;
    private final CudamiFileResourcesMetadataClient cudamiFileResourcesMetadataClient;
    private final CudamiIdentifiablesClient cudamiIdentifiablesClient;
    private final CudamiIdentifierTypesClient cudamiIdentifierTypesClient;
    private final CudamiItemsClient cudamiItemsClient;
    private final CudamiLocalesClient cudamiLocalesClient;
    private final CudamiPersonsClient cudamiPersonsClient;
    private final CudamiPredicatesClient cudamiPredicatesClient;
    private final CudamiProjectsClient cudamiProjectsClient;
    private final CudamiSubtopicsClient cudamiSubtopicsClient;
    private final CudamiTopicsClient cudamiTopicsClient;
    private final CudamiUsersClient cudamiUsersClient;
    private final CudamiWebpagesClient cudamiWebpagesClient;
    private final CudamiWebsitesClient cudamiWebsitesClient;
    private final CudamiWorksClient cudamiWorksClient;

    public CudamiClient(String cudamiServerUrl, ObjectMapper mapper) {
        this(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).connectTimeout(Duration.ofSeconds(10L)).build(), cudamiServerUrl, mapper);
    }

    public CudamiClient(HttpClient http, String cudamiServerUrl, ObjectMapper mapper) {
        this.http = http;
        this.cudamiArticlesClient = new CudamiArticlesClient(http, cudamiServerUrl, mapper);
        this.cudamiCollectionsClient = new CudamiCollectionsClient(http, cudamiServerUrl, mapper);
        this.cudamiCorporateBodiesClient = new CudamiCorporateBodiesClient(http, cudamiServerUrl, mapper);
        this.cudamiDigitalObjectsClient = new CudamiDigitalObjectsClient(http, cudamiServerUrl, mapper);
        this.cudamiEntitiesClient = new CudamiEntitiesClient(http, cudamiServerUrl, mapper);
        this.cudamiEntityPartsClient = new CudamiEntityPartsClient(http, cudamiServerUrl, mapper);
        this.cudamiEntityRelationsClient = new CudamiEntityRelationsClient(http, cudamiServerUrl, mapper);
        this.cudamiFileResourcesBinaryClient = new CudamiFileResourcesBinaryClient(cudamiServerUrl, mapper);
        this.cudamiFileResourcesMetadataClient = new CudamiFileResourcesMetadataClient(http, cudamiServerUrl, mapper);
        this.cudamiIdentifiablesClient = new CudamiIdentifiablesClient(http, cudamiServerUrl, mapper);
        this.cudamiIdentifierTypesClient = new CudamiIdentifierTypesClient(http, cudamiServerUrl, mapper);
        this.cudamiItemsClient = new CudamiItemsClient(http, cudamiServerUrl, mapper);
        this.cudamiLocalesClient = new CudamiLocalesClient(http, cudamiServerUrl, mapper);
        this.cudamiPersonsClient = new CudamiPersonsClient(http, cudamiServerUrl, mapper);
        this.cudamiPredicatesClient = new CudamiPredicatesClient(http, cudamiServerUrl, mapper);
        this.cudamiProjectsClient = new CudamiProjectsClient(http, cudamiServerUrl, mapper);
        this.cudamiSubtopicsClient = new CudamiSubtopicsClient(http, cudamiServerUrl, mapper);
        this.cudamiTopicsClient = new CudamiTopicsClient(http, cudamiServerUrl, mapper);
        this.cudamiUsersClient = new CudamiUsersClient(http, cudamiServerUrl, mapper);
        this.cudamiWebpagesClient = new CudamiWebpagesClient(http, cudamiServerUrl, mapper);
        this.cudamiWebsitesClient = new CudamiWebsitesClient(http, cudamiServerUrl, mapper);
        this.cudamiWorksClient = new CudamiWorksClient(http, cudamiServerUrl, mapper);
    }

    public CudamiArticlesClient forArticles() {
        return this.cudamiArticlesClient;
    }

    public CudamiCollectionsClient forCollections() {
        return this.cudamiCollectionsClient;
    }

    public CudamiCorporateBodiesClient forCorporateBodies() {
        return this.cudamiCorporateBodiesClient;
    }

    public CudamiDigitalObjectsClient forDigitalObjects() {
        return this.cudamiDigitalObjectsClient;
    }

    public CudamiEntitiesClient forEntities() {
        return this.cudamiEntitiesClient;
    }

    public CudamiEntityPartsClient forEntityParts() {
        return this.cudamiEntityPartsClient;
    }

    public CudamiEntityRelationsClient forEntityRelations() {
        return this.cudamiEntityRelationsClient;
    }

    public CudamiFileResourcesBinaryClient forFileResourcesBinary() {
        return this.cudamiFileResourcesBinaryClient;
    }

    public CudamiFileResourcesMetadataClient forFileResourcesMetadata() {
        return this.cudamiFileResourcesMetadataClient;
    }

    public CudamiIdentifiablesClient forIdentifiables() {
        return this.cudamiIdentifiablesClient;
    }

    public CudamiIdentifierTypesClient forIdentifierTypes() {
        return this.cudamiIdentifierTypesClient;
    }

    public CudamiItemsClient forItems() {
        return this.cudamiItemsClient;
    }

    public CudamiLocalesClient forLocales() {
        return this.cudamiLocalesClient;
    }

    public CudamiPersonsClient forPersons() {
        return this.cudamiPersonsClient;
    }

    public CudamiPredicatesClient forPredicates() {
        return this.cudamiPredicatesClient;
    }

    public CudamiProjectsClient forProjects() {
        return this.cudamiProjectsClient;
    }

    public CudamiSubtopicsClient forSubtopics() {
        return this.cudamiSubtopicsClient;
    }

    public CudamiTopicsClient forTopics() {
        return this.cudamiTopicsClient;
    }

    public CudamiUsersClient forUsers() {
        return this.cudamiUsersClient;
    }

    public CudamiWebpagesClient forWebpages() {
        return this.cudamiWebpagesClient;
    }

    public CudamiWebsitesClient forWebsites() {
        return this.cudamiWebsitesClient;
    }

    public CudamiWorksClient forWorks() {
        return this.cudamiWorksClient;
    }
}

