/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiBaseClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Collection;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.api.view.BreadcrumbNavigation;
import de.digitalcollections.model.impl.identifiable.entity.CollectionImpl;
import de.digitalcollections.model.impl.identifiable.entity.DigitalObjectImpl;
import de.digitalcollections.model.impl.paging.SearchPageRequestImpl;
import de.digitalcollections.model.impl.view.BreadcrumbNavigationImpl;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiCollectionsClient
extends CudamiBaseClient<CollectionImpl> {
    public CudamiCollectionsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, CollectionImpl.class, mapper);
    }

    public boolean addDigitalObject(UUID collectionUuid, UUID digitalObjectUuid) throws HttpException {
        return Boolean.parseBoolean(this.doPostRequestForString(String.format("/latest/collections/%s/digitalobjects/%s", collectionUuid, digitalObjectUuid)));
    }

    public boolean addDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) throws HttpException {
        return Boolean.parseBoolean(this.doPostRequestForString(String.format("/latest/collections/%s/digitalobjects", collectionUuid), digitalObjects));
    }

    public boolean addSubcollection(UUID collectionUuid, UUID subcollectionUuid) throws HttpException {
        return Boolean.parseBoolean(this.doPostRequestForString(String.format("/latest/collections/%s/subcollections/%s", collectionUuid, subcollectionUuid)));
    }

    public boolean addSubcollections(UUID collectionUuid, List<Collection> subcollections) throws HttpException {
        return Boolean.parseBoolean(this.doPostRequestForString(String.format("/latest/collections/%s/subcollections", collectionUuid), subcollections));
    }

    public long count() throws HttpException {
        return Long.parseLong(this.doGetRequestForString("/latest/collections/count"));
    }

    public Collection create() {
        return new CollectionImpl();
    }

    public PageResponse<CollectionImpl> find(PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList("/latest/collections", pageRequest);
    }

    public SearchPageResponse<CollectionImpl> find(SearchPageRequest searchPageRequest) throws HttpException {
        return this.doGetSearchRequestForPagedObjectList("/latest/collections/search", searchPageRequest);
    }

    public List<CollectionImpl> find(String searchTerm, int maxResults) throws HttpException {
        SearchPageRequestImpl searchPageRequest = new SearchPageRequestImpl(searchTerm, 0, maxResults, null);
        SearchPageResponse<CollectionImpl> response = this.find((SearchPageRequest)searchPageRequest);
        return response.getContent();
    }

    public PageResponse<CollectionImpl> findActive(PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList(String.format("/latest/collections?active=true", new Object[0]), pageRequest);
    }

    public Collection findActiveOne(UUID uuid, Locale locale) throws HttpException {
        return (Collection)this.doGetRequestForObject(String.format("/latest/collections/%s?active=true&pLocale=%s", uuid, locale));
    }

    public Collection findOne(UUID uuid) throws HttpException {
        return (Collection)this.doGetRequestForObject(String.format("/latest/collections/%s", uuid));
    }

    public Collection findOne(UUID uuid, Locale locale) throws HttpException {
        return this.findOne(uuid, locale.toString());
    }

    public Collection findOne(UUID uuid, String locale) throws HttpException {
        return (Collection)this.doGetRequestForObject(String.format("/latest/collections/%s?pLocale=%s", uuid, locale));
    }

    public Collection findOneByIdentifier(String namespace, String id) throws HttpException {
        return (Collection)this.doGetRequestForObject(String.format("/latest/collections/identifier/%s:%s.json", namespace, id));
    }

    public PageResponse<CollectionImpl> findTopCollections(PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList("/latest/collections/top", pageRequest);
    }

    public PageResponse<Collection> getActiveSubcollections(UUID uuid, PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList(String.format("/latest/collections/%s/subcollections?active=true", uuid), pageRequest, CollectionImpl.class);
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID uuid) throws HttpException {
        return (BreadcrumbNavigation)this.doGetRequestForObject(String.format("/latest/collections/%s/breadcrumb", uuid), BreadcrumbNavigationImpl.class);
    }

    public PageResponse<DigitalObject> getDigitalObjects(UUID collectionUuid, PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList(String.format("/latest/collections/%s/digitalobjects", collectionUuid), pageRequest, DigitalObjectImpl.class);
    }

    public Collection getParent(UUID uuid) throws HttpException {
        return (Collection)this.doGetRequestForObject(String.format("/latest/collections/%s/parent", uuid), CollectionImpl.class);
    }

    public List<CollectionImpl> getParents(UUID uuid) throws HttpException {
        return this.doGetRequestForObjectList(String.format("/latest/collections/%s/parents", uuid));
    }

    public PageResponse<Collection> getSubcollections(UUID uuid, PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList(String.format("/latest/collections/%s/subcollections", uuid), pageRequest, CollectionImpl.class);
    }

    public boolean removeDigitalObject(UUID collectionUuid, UUID digitalObjectUuid) throws HttpException {
        return Boolean.parseBoolean(this.doDeleteRequestForString(String.format("/latest/collections/%s/digitalobjects/%s", collectionUuid, digitalObjectUuid)));
    }

    public boolean removeSubcollection(UUID collectionUuid, UUID subcollectionUuid) throws HttpException {
        return Boolean.parseBoolean(this.doDeleteRequestForString(String.format("/latest/collections/%s/subcollections/%s", collectionUuid, subcollectionUuid)));
    }

    public Collection save(Collection collection) throws HttpException {
        return (Collection)this.doPostRequestForObject("/latest/collections", (CollectionImpl)collection);
    }

    public boolean saveDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) throws HttpException {
        return Boolean.parseBoolean((String)this.doPutRequestForObject(String.format("/latest/collections/%s/digitalobjects", collectionUuid), digitalObjects, String.class));
    }

    public Collection saveWithParentCollection(Collection collection, UUID parentCollectionUuid) throws HttpException {
        return (Collection)this.doPostRequestForObject(String.format("/latest/collections/%s/collection", parentCollectionUuid), (CollectionImpl)collection);
    }

    public Collection update(UUID uuid, Collection collection) throws HttpException {
        return (Collection)this.doPutRequestForObject(String.format("/latest/collections/%s", uuid), (CollectionImpl)collection);
    }
}

