/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiBaseClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Collection;
import de.digitalcollections.model.api.identifiable.entity.DigitalObject;
import de.digitalcollections.model.api.identifiable.entity.Project;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.impl.identifiable.entity.CollectionImpl;
import de.digitalcollections.model.impl.identifiable.entity.DigitalObjectImpl;
import de.digitalcollections.model.impl.identifiable.entity.ProjectImpl;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.identifiable.resource.ImageFileResourceImpl;
import de.digitalcollections.model.impl.paging.SearchPageRequestImpl;
import java.net.http.HttpClient;
import java.util.List;
import java.util.UUID;

public class CudamiDigitalObjectsClient
extends CudamiBaseClient<DigitalObjectImpl> {
    public CudamiDigitalObjectsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, DigitalObjectImpl.class, mapper);
    }

    public DigitalObject create() {
        return new DigitalObjectImpl();
    }

    public long count() throws HttpException {
        return Long.parseLong(this.doGetRequestForString("/latest/digitalobjects/count"));
    }

    public PageResponse<DigitalObjectImpl> find(PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList("/latest/digitalobjects", pageRequest);
    }

    public SearchPageResponse<DigitalObjectImpl> find(SearchPageRequest searchPageRequest) throws HttpException {
        return this.doGetSearchRequestForPagedObjectList("/latest/digitalobjects/search", searchPageRequest);
    }

    public List<DigitalObjectImpl> find(String searchTerm, int maxResults) throws HttpException {
        SearchPageRequestImpl searchPageRequest = new SearchPageRequestImpl(searchTerm, 0, maxResults, null);
        SearchPageResponse<DigitalObjectImpl> response = this.find((SearchPageRequest)searchPageRequest);
        return response.getContent();
    }

    public DigitalObject findOne(UUID uuid) throws HttpException {
        return (DigitalObject)this.doGetRequestForObject(String.format("/latest/digitalobjects/%s", uuid));
    }

    public DigitalObject findOneByIdentifier(String namespace, String id) throws HttpException {
        return (DigitalObject)this.doGetRequestForObject(String.format("/latest/digitalobjects/identifier/%s:%s.json", namespace, id));
    }

    public List<DigitalObject> findAllReduced() throws HttpException {
        return this.doGetRequestForObjectList("/latest/digitalobjects/reduced", DigitalObjectImpl.class);
    }

    public PageResponse<Collection> getActiveCollections(UUID uuid, PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList(String.format("/latest/digitalobjects/%s/collections?active=true", uuid), pageRequest, CollectionImpl.class);
    }

    public PageResponse<Collection> getCollections(UUID uuid, PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList(String.format("/latest/digitalobjects/%s/collections", uuid), pageRequest, CollectionImpl.class);
    }

    public List<FileResource> getFileResources(UUID uuid) throws HttpException {
        return this.doGetRequestForObjectList(String.format("/latest/digitalobjects/%s/fileresources", uuid), FileResourceImpl.class);
    }

    public List<ImageFileResource> getImageFileResources(UUID uuid) throws HttpException {
        return this.doGetRequestForObjectList(String.format("/latest/digitalobjects/%s/fileresources/images", uuid), ImageFileResourceImpl.class);
    }

    public PageResponse<Project> getProjects(UUID uuid, PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList(String.format("/latest/digitalobjects/%s/projects", uuid), pageRequest, ProjectImpl.class);
    }

    public DigitalObject save(DigitalObject digitalObject) throws HttpException {
        return (DigitalObject)this.doPostRequestForObject("/latest/digitalobjects", (DigitalObjectImpl)digitalObject);
    }

    public List<FileResource> saveFileResources(UUID uuid, List fileResources) throws HttpException {
        return this.doPostRequestForObjectList(String.format("/latest/digitalobjects/%s/fileresources", uuid), fileResources, FileResourceImpl.class);
    }

    public DigitalObject update(UUID uuid, DigitalObject digitalObject) throws HttpException {
        return (DigitalObject)this.doPutRequestForObject(String.format("/latest/digitalobjects/%s", uuid), (DigitalObjectImpl)digitalObject);
    }

    public boolean delete(UUID uuid) throws HttpException {
        return Boolean.parseBoolean(this.doDeleteRequestForString(String.format("/latest/digitalobjects/%s", uuid)));
    }
}

