/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiBaseClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.entity.Entity;
import de.digitalcollections.model.api.identifiable.entity.relation.EntityRelation;
import de.digitalcollections.model.api.identifiable.resource.FileResource;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.impl.identifiable.entity.EntityImpl;
import de.digitalcollections.model.impl.identifiable.entity.relation.EntityRelationImpl;
import de.digitalcollections.model.impl.identifiable.resource.FileResourceImpl;
import de.digitalcollections.model.impl.paging.PageRequestImpl;
import de.digitalcollections.model.impl.paging.SearchPageRequestImpl;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiEntitiesClient
extends CudamiBaseClient<EntityImpl> {
    public CudamiEntitiesClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, EntityImpl.class, mapper);
    }

    public void addRelatedFileresource(UUID uuid, UUID fileResourceUuid) throws HttpException {
        this.doPostRequestForObject(String.format("/latest/entities/%s/related/fileresources/%s", uuid, fileResourceUuid), (EntityImpl)null);
    }

    public void addRelation(UUID subjectEntityUuid, String predicate, UUID objectEntityUuid) throws HttpException {
        this.doPostRequestForObject(String.format("/latest/entities/relations/%s/%s/%s", subjectEntityUuid, predicate, objectEntityUuid), (EntityImpl)null);
    }

    public long count() throws HttpException {
        return Long.parseLong(this.doGetRequestForString("/latest/entities/count"));
    }

    public Entity create() {
        return new EntityImpl();
    }

    public PageResponse<EntityImpl> find(PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList("/latest/entities", pageRequest);
    }

    public SearchPageResponse<EntityImpl> find(SearchPageRequest searchPageRequest) throws HttpException {
        return this.doGetSearchRequestForPagedObjectList("/latest/entities/search", searchPageRequest);
    }

    public List<EntityImpl> find(String searchTerm, int maxResults) throws HttpException {
        SearchPageRequestImpl searchPageRequest = new SearchPageRequestImpl(searchTerm, 0, maxResults, null);
        SearchPageResponse<EntityImpl> response = this.find((SearchPageRequest)searchPageRequest);
        return response.getContent();
    }

    public Entity findOne(UUID uuid) throws HttpException {
        return (Entity)this.doGetRequestForObject(String.format("/latest/entities/%s", uuid));
    }

    public Entity findOne(UUID uuid, Locale locale) throws HttpException {
        return this.findOne(uuid, locale.toString());
    }

    public Entity findOne(UUID uuid, String locale) throws HttpException {
        return (Entity)this.doGetRequestForObject(String.format("/latest/entities/%s?locale=%s", uuid, locale));
    }

    public Entity findOneByIdentifier(String namespace, String id) throws HttpException {
        return (Entity)this.doGetRequestForObject(String.format("/latest/entities/identifier/%s:%s.json", namespace, id));
    }

    public Entity findOneByRefId(long refId) throws HttpException {
        return (Entity)this.doGetRequestForObject(String.format("/latest/entities/%d", refId));
    }

    public PageResponse<EntityImpl> findRandomEntities(int count) throws HttpException {
        PageRequestImpl pageRequest = new PageRequestImpl(0, count, null);
        return this.doGetRequestForPagedObjectList("/latest/entities/random", (PageRequest)pageRequest);
    }

    public List getRelatedFileResources(UUID uuid) throws HttpException {
        return this.doGetRequestForObjectList(String.format("/latest/entities/%s/related/fileresources", uuid), FileResourceImpl.class);
    }

    public List<EntityRelation> getRelations(UUID subjectEntityUuid) throws HttpException {
        return this.doGetRequestForObjectList(String.format("/latest/entities/relations/%s", subjectEntityUuid), EntityRelationImpl.class);
    }

    public Entity save(Entity entity) throws HttpException {
        return (Entity)this.doPostRequestForObject("/latest/entities", (EntityImpl)entity);
    }

    public List<FileResource> saveRelatedFileResources(UUID uuid, List fileResources) throws HttpException {
        return this.doPostRequestForObjectList(String.format("/latest/entities/%s/related/fileresources", uuid), fileResources, FileResourceImpl.class);
    }

    public List<EntityRelation> saveRelationsForSubject(List relations) throws HttpException {
        return this.doPutRequestForObjectList(String.format("/latest/entities/%s/relations", ((EntityRelation)relations.get(0)).getSubject().getUuid()), relations, EntityRelationImpl.class);
    }

    public Entity update(UUID uuid, Entity entity) throws HttpException {
        return (Entity)this.doPutRequestForObject(String.format("/latest/entities/%s", uuid), (EntityImpl)entity);
    }
}

