/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiBaseClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.api.identifiable.Identifiable;
import de.digitalcollections.model.api.paging.PageRequest;
import de.digitalcollections.model.api.paging.PageResponse;
import de.digitalcollections.model.api.paging.SearchPageRequest;
import de.digitalcollections.model.api.paging.SearchPageResponse;
import de.digitalcollections.model.impl.identifiable.IdentifiableImpl;
import de.digitalcollections.model.impl.paging.SearchPageRequestImpl;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiIdentifiablesClient
extends CudamiBaseClient<IdentifiableImpl> {
    public CudamiIdentifiablesClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, IdentifiableImpl.class, mapper);
    }

    public Identifiable create() {
        return new IdentifiableImpl();
    }

    public long count() throws HttpException {
        return Long.parseLong(this.doGetRequestForString("/latest/identifiables/count"));
    }

    public PageResponse<IdentifiableImpl> find(PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList("/latest/identifiables", pageRequest);
    }

    public SearchPageResponse<IdentifiableImpl> find(SearchPageRequest searchPageRequest) throws HttpException {
        return this.doGetSearchRequestForPagedObjectList("/latest/identifiables/search", searchPageRequest);
    }

    public List<IdentifiableImpl> find(String searchTerm, int maxResults) throws HttpException {
        SearchPageRequestImpl searchPageRequest = new SearchPageRequestImpl(searchTerm, 0, maxResults, null);
        SearchPageResponse<IdentifiableImpl> response = this.find((SearchPageRequest)searchPageRequest);
        return response.getContent();
    }

    public Identifiable findOne(UUID uuid) throws HttpException {
        return (Identifiable)this.doGetRequestForObject(String.format("/latest/identifiables/%s", uuid));
    }

    public Identifiable findOneByIdentifier(String namespace, String id) throws HttpException {
        return (Identifiable)this.doGetRequestForObject(String.format("/latest/identifiables/identifier/%s:%s.json", namespace, id));
    }

    public Identifiable findOne(UUID uuid, Locale locale) throws HttpException {
        return this.findOne(uuid, locale.toString());
    }

    public Identifiable findOne(UUID uuid, String locale) throws HttpException {
        return (Identifiable)this.doGetRequestForObject(String.format("/latest/identifiables/%s?locale=%s", uuid, locale));
    }

    public Identifiable save(Identifiable identifiable) throws HttpException {
        return (Identifiable)this.doPostRequestForObject("/latest/identifiables", (IdentifiableImpl)identifiable);
    }

    public Identifiable update(UUID uuid, Identifiable identifiable) throws HttpException {
        return (Identifiable)this.doPutRequestForObject(String.format("/latest/identifiables/%s", uuid), (IdentifiableImpl)identifiable);
    }
}

