/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiBaseClient;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import java.lang.reflect.InvocationTargetException;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiIdentifiablesClient<I extends Identifiable>
extends CudamiBaseClient<I> {
    protected final String baseEndpoint;
    private Class<I> typeArgumentClass;

    public CudamiIdentifiablesClient(HttpClient http, String serverUrl, Class<I> identifiableClass, ObjectMapper mapper, String baseEndpoint) {
        super(http, serverUrl, identifiableClass, mapper);
        this.baseEndpoint = baseEndpoint;
        this.typeArgumentClass = identifiableClass;
    }

    public CudamiIdentifiablesClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        this(http, serverUrl, Identifiable.class, mapper, "/v5/identifiables");
    }

    public long count() throws HttpException {
        return Long.parseLong(this.doGetRequestForString(this.baseEndpoint + "/count"));
    }

    public I create() {
        try {
            return (I)((Identifiable)this.typeArgumentClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]));
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Cannot create new instance of " + this.typeArgumentClass.getName() + ": " + e, e);
        }
    }

    public PageResponse<I> find(PageRequest pageRequest) throws HttpException {
        return this.doGetRequestForPagedObjectList(this.baseEndpoint, pageRequest);
    }

    public SearchPageResponse<I> find(SearchPageRequest searchPageRequest) throws HttpException {
        return this.doGetSearchRequestForPagedObjectList(this.baseEndpoint + "/search", searchPageRequest);
    }

    public List<I> find(String searchTerm, int maxResults) throws HttpException {
        SearchPageRequest searchPageRequest = new SearchPageRequest(searchTerm, 0, maxResults, null);
        SearchPageResponse<I> response = this.find(searchPageRequest);
        return response.getContent();
    }

    public I findOne(UUID uuid) throws HttpException {
        return (I)((Identifiable)this.doGetRequestForObject(String.format(this.baseEndpoint + "/%s", uuid)));
    }

    public I findOne(UUID uuid, Locale locale) throws HttpException {
        return this.findOne(uuid, locale.toString());
    }

    public I findOne(UUID uuid, String locale) throws HttpException {
        return (I)((Identifiable)this.doGetRequestForObject(String.format(this.baseEndpoint + "/%s?locale=%s", uuid, locale)));
    }

    public I findOneByIdentifier(String namespace, String id) throws HttpException {
        return (I)((Identifiable)this.doGetRequestForObject(String.format(this.baseEndpoint + "/identifier/%s:%s.json", namespace, id)));
    }

    public I save(I identifiable) throws HttpException {
        return (I)((Identifiable)this.doPostRequestForObject(this.baseEndpoint, identifiable));
    }

    public I update(UUID uuid, I identifiable) throws HttpException {
        return (I)((Identifiable)this.doPutRequestForObject(String.format(this.baseEndpoint + "/%s", uuid), identifiable));
    }

    public String getBaseEndpoint() {
        return this.baseEndpoint;
    }
}

