/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.entity;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.work.Item;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiDigitalObjectsClient
extends CudamiIdentifiablesClient<DigitalObject> {
    public CudamiDigitalObjectsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, DigitalObject.class, mapper, "/v5/digitalobjects");
    }

    public boolean delete(UUID uuid) throws HttpException {
        return Boolean.parseBoolean(this.doDeleteRequestForString(String.format("%s/%s", this.baseEndpoint, uuid)));
    }

    public List<DigitalObject> findAllReduced() throws HttpException {
        return this.doGetRequestForObjectList(this.baseEndpoint + "/reduced", DigitalObject.class);
    }

    public DigitalObject findOneByRefId(long refId) throws HttpException {
        return (DigitalObject)this.doGetRequestForObject(String.format("%s/%s", this.baseEndpoint, refId));
    }

    public PageResponse<DigitalObject> findRandomDigitalObjects(int count) throws HttpException {
        PageRequest pageRequest = new PageRequest(0, count, null);
        return this.doGetRequestForPagedObjectList(this.baseEndpoint + "/random", pageRequest);
    }

    public SearchPageResponse<Collection> getActiveCollections(UUID uuid, SearchPageRequest searchPageRequest) throws HttpException {
        return this.doGetSearchRequestForPagedObjectList(String.format("%s/%s/collections?active=true", this.baseEndpoint, uuid), searchPageRequest, Collection.class);
    }

    public SearchPageResponse<Collection> getCollections(UUID uuid, SearchPageRequest searchPageRequest) throws HttpException {
        return this.doGetSearchRequestForPagedObjectList(String.format("%s/%s/collections", this.baseEndpoint, uuid), searchPageRequest, Collection.class);
    }

    public List<FileResource> getFileResources(UUID uuid) throws HttpException {
        return this.doGetRequestForObjectList(String.format("%s/%s/fileresources", this.baseEndpoint, uuid), FileResource.class);
    }

    public List<ImageFileResource> getImageFileResources(UUID uuid) throws HttpException {
        return this.doGetRequestForObjectList(String.format("%s/%s/fileresources/images", this.baseEndpoint, uuid), ImageFileResource.class);
    }

    public Item getItem(UUID uuid) throws HttpException {
        return (Item)this.doGetRequestForObject(String.format("%s/%s/item", this.baseEndpoint, uuid), Item.class);
    }

    public List<Locale> getLanguagesOfCollections(UUID uuid) throws HttpException {
        return this.doGetRequestForObjectList(String.format("%s/%s/collections/languages", this.baseEndpoint, uuid), Locale.class);
    }

    public List<Locale> getLanguagesOfProjects(UUID uuid) throws HttpException {
        return this.doGetRequestForObjectList(String.format("%s/%s/projects/languages", this.baseEndpoint, uuid), Locale.class);
    }

    public SearchPageResponse<Project> getProjects(UUID uuid, SearchPageRequest searchPageRequest) throws HttpException {
        return this.doGetSearchRequestForPagedObjectList(String.format("%s/%s/projects", this.baseEndpoint, uuid), searchPageRequest, Project.class);
    }

    public List<FileResource> saveFileResources(UUID uuid, List fileResources) throws HttpException {
        return this.doPostRequestForObjectList(String.format("%s/%s/fileresources", this.baseEndpoint, uuid), fileResources, FileResource.class);
    }

    public List<Locale> getLanguages() throws HttpException {
        return this.doGetRequestForObjectList(this.baseEndpoint + "/languages", Locale.class);
    }
}

