/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiLocalesClient;
import de.digitalcollections.cudami.client.config.CudamiConfigClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifierTypesClient;
import de.digitalcollections.cudami.client.identifiable.agent.CudamiFamilyNamesClient;
import de.digitalcollections.cudami.client.identifiable.agent.CudamiGivenNamesClient;
import de.digitalcollections.cudami.client.identifiable.alias.CudamiUrlAliasClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiArticlesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiCollectionsClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiDigitalObjectsClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiHeadwordEntriesClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiProjectsClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiTopicsClient;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiWebsitesClient;
import de.digitalcollections.cudami.client.identifiable.entity.agent.CudamiCorporateBodiesClient;
import de.digitalcollections.cudami.client.identifiable.entity.agent.CudamiPersonsClient;
import de.digitalcollections.cudami.client.identifiable.entity.geo.location.CudamiGeoLocationsClient;
import de.digitalcollections.cudami.client.identifiable.entity.geo.location.CudamiHumanSettlementsClient;
import de.digitalcollections.cudami.client.identifiable.entity.relation.CudamiEntityRelationsClient;
import de.digitalcollections.cudami.client.identifiable.entity.work.CudamiItemsClient;
import de.digitalcollections.cudami.client.identifiable.entity.work.CudamiWorksClient;
import de.digitalcollections.cudami.client.identifiable.resource.CudamiFileResourcesBinaryClient;
import de.digitalcollections.cudami.client.identifiable.resource.CudamiFileResourcesMetadataClient;
import de.digitalcollections.cudami.client.identifiable.web.CudamiWebpagesClient;
import de.digitalcollections.cudami.client.relation.CudamiPredicatesClient;
import de.digitalcollections.cudami.client.security.CudamiUsersClient;
import de.digitalcollections.cudami.client.semantic.CudamiHeadwordsClient;
import de.digitalcollections.cudami.client.view.CudamiRenderingTemplatesClient;
import java.net.http.HttpClient;
import java.time.Duration;

public class CudamiClient {
    private final CudamiArticlesClient cudamiArticlesClient;
    private final CudamiCollectionsClient cudamiCollectionsClient;
    private final CudamiConfigClient cudamiConfigClient;
    private final CudamiCorporateBodiesClient cudamiCorporateBodiesClient;
    private final CudamiDigitalObjectsClient cudamiDigitalObjectsClient;
    private final CudamiEntitiesClient cudamiEntitiesClient;
    private final CudamiEntityRelationsClient cudamiEntityRelationsClient;
    private final CudamiFamilyNamesClient cudamiFamilyNamesClient;
    private final CudamiFileResourcesBinaryClient cudamiFileResourcesBinaryClient;
    private final CudamiFileResourcesMetadataClient cudamiFileResourcesMetadataClient;
    private final CudamiGeoLocationsClient cudamiGeoLocationsClient;
    private final CudamiGivenNamesClient cudamiGivenNamesClient;
    private final CudamiHeadwordEntriesClient cudamiHeadwordEntriesClient;
    private final CudamiHeadwordsClient cudamiHeadwordsClient;
    private final CudamiHumanSettlementsClient cudamiHumanSettlementsClient;
    private final CudamiIdentifiablesClient cudamiIdentifiablesClient;
    private final CudamiIdentifierTypesClient cudamiIdentifierTypesClient;
    private final CudamiItemsClient cudamiItemsClient;
    private final CudamiLocalesClient cudamiLocalesClient;
    private final CudamiPersonsClient cudamiPersonsClient;
    private final CudamiPredicatesClient cudamiPredicatesClient;
    private final CudamiProjectsClient cudamiProjectsClient;
    private final CudamiRenderingTemplatesClient cudamiRenderingTemplatesClient;
    private final CudamiTopicsClient cudamiTopicsClient;
    private final CudamiUrlAliasClient cudamiUrlAliasClient;
    private final CudamiUsersClient cudamiUsersClient;
    private final CudamiWebpagesClient cudamiWebpagesClient;
    private final CudamiWebsitesClient cudamiWebsitesClient;
    private final CudamiWorksClient cudamiWorksClient;
    protected final HttpClient http;

    public CudamiClient(String cudamiServerUrl, ObjectMapper mapper) {
        this(HttpClient.newBuilder().followRedirects(HttpClient.Redirect.ALWAYS).connectTimeout(Duration.ofSeconds(10L)).version(HttpClient.Version.HTTP_1_1).build(), cudamiServerUrl, mapper);
    }

    public CudamiClient(HttpClient http, String cudamiServerUrl, ObjectMapper mapper) {
        this.http = http;
        this.cudamiArticlesClient = new CudamiArticlesClient(http, cudamiServerUrl, mapper);
        this.cudamiCollectionsClient = new CudamiCollectionsClient(http, cudamiServerUrl, mapper);
        this.cudamiConfigClient = new CudamiConfigClient(http, cudamiServerUrl, mapper);
        this.cudamiCorporateBodiesClient = new CudamiCorporateBodiesClient(http, cudamiServerUrl, mapper);
        this.cudamiDigitalObjectsClient = new CudamiDigitalObjectsClient(http, cudamiServerUrl, mapper);
        this.cudamiEntitiesClient = new CudamiEntitiesClient(http, cudamiServerUrl, mapper);
        this.cudamiEntityRelationsClient = new CudamiEntityRelationsClient(http, cudamiServerUrl, mapper);
        this.cudamiFamilyNamesClient = new CudamiFamilyNamesClient(http, cudamiServerUrl, mapper);
        this.cudamiFileResourcesBinaryClient = new CudamiFileResourcesBinaryClient(cudamiServerUrl, mapper);
        this.cudamiFileResourcesMetadataClient = new CudamiFileResourcesMetadataClient(http, cudamiServerUrl, mapper);
        this.cudamiGeoLocationsClient = new CudamiGeoLocationsClient(http, cudamiServerUrl, mapper);
        this.cudamiGivenNamesClient = new CudamiGivenNamesClient(http, cudamiServerUrl, mapper);
        this.cudamiHeadwordsClient = new CudamiHeadwordsClient(http, cudamiServerUrl, mapper);
        this.cudamiHeadwordEntriesClient = new CudamiHeadwordEntriesClient(http, cudamiServerUrl, mapper);
        this.cudamiHumanSettlementsClient = new CudamiHumanSettlementsClient(http, cudamiServerUrl, mapper);
        this.cudamiIdentifiablesClient = new CudamiIdentifiablesClient(http, cudamiServerUrl, mapper);
        this.cudamiIdentifierTypesClient = new CudamiIdentifierTypesClient(http, cudamiServerUrl, mapper);
        this.cudamiItemsClient = new CudamiItemsClient(http, cudamiServerUrl, mapper);
        this.cudamiLocalesClient = new CudamiLocalesClient(http, cudamiServerUrl, mapper);
        this.cudamiPersonsClient = new CudamiPersonsClient(http, cudamiServerUrl, mapper);
        this.cudamiPredicatesClient = new CudamiPredicatesClient(http, cudamiServerUrl, mapper);
        this.cudamiProjectsClient = new CudamiProjectsClient(http, cudamiServerUrl, mapper);
        this.cudamiRenderingTemplatesClient = new CudamiRenderingTemplatesClient(http, cudamiServerUrl, mapper);
        this.cudamiTopicsClient = new CudamiTopicsClient(http, cudamiServerUrl, mapper);
        this.cudamiUrlAliasClient = new CudamiUrlAliasClient(http, cudamiServerUrl, mapper);
        this.cudamiUsersClient = new CudamiUsersClient(http, cudamiServerUrl, mapper);
        this.cudamiWebpagesClient = new CudamiWebpagesClient(http, cudamiServerUrl, mapper);
        this.cudamiWebsitesClient = new CudamiWebsitesClient(http, cudamiServerUrl, mapper);
        this.cudamiWorksClient = new CudamiWorksClient(http, cudamiServerUrl, mapper);
    }

    public CudamiArticlesClient forArticles() {
        return this.cudamiArticlesClient;
    }

    public CudamiCollectionsClient forCollections() {
        return this.cudamiCollectionsClient;
    }

    public CudamiConfigClient forConfig() {
        return this.cudamiConfigClient;
    }

    public CudamiCorporateBodiesClient forCorporateBodies() {
        return this.cudamiCorporateBodiesClient;
    }

    public CudamiDigitalObjectsClient forDigitalObjects() {
        return this.cudamiDigitalObjectsClient;
    }

    public CudamiEntitiesClient forEntities() {
        return this.cudamiEntitiesClient;
    }

    public CudamiEntityRelationsClient forEntityRelations() {
        return this.cudamiEntityRelationsClient;
    }

    public CudamiFamilyNamesClient forFamilyNames() {
        return this.cudamiFamilyNamesClient;
    }

    public CudamiFileResourcesBinaryClient forFileResourcesBinary() {
        return this.cudamiFileResourcesBinaryClient;
    }

    public CudamiFileResourcesMetadataClient forFileResourcesMetadata() {
        return this.cudamiFileResourcesMetadataClient;
    }

    public CudamiGeoLocationsClient forGeoLocations() {
        return this.cudamiGeoLocationsClient;
    }

    public CudamiGivenNamesClient forGivenNames() {
        return this.cudamiGivenNamesClient;
    }

    public CudamiHeadwordEntriesClient forHeadwordEntries() {
        return this.cudamiHeadwordEntriesClient;
    }

    public CudamiHeadwordsClient forHeadwords() {
        return this.cudamiHeadwordsClient;
    }

    public CudamiHumanSettlementsClient forHumanSettlements() {
        return this.cudamiHumanSettlementsClient;
    }

    public CudamiIdentifiablesClient forIdentifiables() {
        return this.cudamiIdentifiablesClient;
    }

    public CudamiIdentifierTypesClient forIdentifierTypes() {
        return this.cudamiIdentifierTypesClient;
    }

    public CudamiItemsClient forItems() {
        return this.cudamiItemsClient;
    }

    public CudamiLocalesClient forLocales() {
        return this.cudamiLocalesClient;
    }

    public CudamiPersonsClient forPersons() {
        return this.cudamiPersonsClient;
    }

    public CudamiPredicatesClient forPredicates() {
        return this.cudamiPredicatesClient;
    }

    public CudamiProjectsClient forProjects() {
        return this.cudamiProjectsClient;
    }

    public CudamiRenderingTemplatesClient forRenderingTemplates() {
        return this.cudamiRenderingTemplatesClient;
    }

    public CudamiTopicsClient forTopics() {
        return this.cudamiTopicsClient;
    }

    public CudamiUrlAliasClient forUrlAliases() {
        return this.cudamiUrlAliasClient;
    }

    public CudamiUsersClient forUsers() {
        return this.cudamiUsersClient;
    }

    public CudamiWebpagesClient forWebpages() {
        return this.cudamiWebpagesClient;
    }

    public CudamiWebsitesClient forWebsites() {
        return this.cudamiWebsitesClient;
    }

    public CudamiWorksClient forWorks() {
        return this.cudamiWorksClient;
    }
}

