/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import de.digitalcollections.cudami.client.exceptions.CudamiRestErrorDecoder;
import de.digitalcollections.cudami.client.exceptions.HttpException;
import de.digitalcollections.model.filter.FilterCriterion;
import de.digitalcollections.model.filter.Filtering;
import de.digitalcollections.model.paging.Direction;
import de.digitalcollections.model.paging.NullHandling;
import de.digitalcollections.model.paging.Order;
import de.digitalcollections.model.paging.PageRequest;
import de.digitalcollections.model.paging.PageResponse;
import de.digitalcollections.model.paging.SearchPageRequest;
import de.digitalcollections.model.paging.SearchPageResponse;
import de.digitalcollections.model.paging.Sorting;
import java.io.IOException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CudamiBaseClient<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CudamiBaseClient.class);
    protected final HttpClient http;
    protected final ObjectMapper mapper;
    protected final ObjectReader reader;
    protected final URI serverUri;
    protected final Class<T> targetType;

    public CudamiBaseClient(HttpClient http, String serverUrl, Class<T> targetType, ObjectMapper mapper) {
        this.http = http;
        this.mapper = mapper;
        this.reader = mapper.reader().forType(targetType);
        this.serverUri = URI.create(serverUrl);
        this.targetType = targetType;
    }

    private HttpRequest createDeleteRequest(String requestUrl) {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("DELETE " + url);
        HttpRequest req = HttpRequest.newBuilder().DELETE().uri(url).header("Accept", "application/json").build();
        return req;
    }

    protected URI createFullUri(String requestUrl) {
        return this.serverUri.resolve(this.serverUri.getPath() + requestUrl);
    }

    private HttpRequest createGetRequest(String requestUrl) {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("GET " + url);
        HttpRequest req = HttpRequest.newBuilder().GET().uri(url).header("Accept", "application/json").build();
        return req;
    }

    private HttpRequest createPatchRequest(String requestUrl) {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("PATCH " + url);
        HttpRequest req = HttpRequest.newBuilder().method("PATCH", HttpRequest.BodyPublishers.noBody()).uri(url).header("Accept", "application/json").build();
        return req;
    }

    private HttpRequest createPatchRequest(String requestUrl, Object bodyObject) throws JsonProcessingException {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("PATCH " + url + " with body");
        HttpRequest req = HttpRequest.newBuilder().method("PATCH", HttpRequest.BodyPublishers.ofString(this.mapper.writeValueAsString(bodyObject))).uri(url).header("Content-Type", "application/json").header("Accept", "application/json").build();
        return req;
    }

    private HttpRequest createPostRequest(String requestUrl) throws JsonProcessingException {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("POST " + url);
        HttpRequest req = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.noBody()).uri(url).header("Content-Type", "application/json").header("Accept", "application/json").build();
        return req;
    }

    private HttpRequest createPostRequest(String requestUrl, Object bodyObject) throws JsonProcessingException {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("POST " + url + " with body");
        HttpRequest req = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(this.mapper.writeValueAsString(bodyObject))).uri(url).header("Content-Type", "application/json").header("Accept", "application/json").build();
        return req;
    }

    private HttpRequest createPutRequest(String requestUrl, Object bodyObject) throws JsonProcessingException {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("PUT " + url + " with body");
        HttpRequest req = HttpRequest.newBuilder().PUT(HttpRequest.BodyPublishers.ofString(this.mapper.writeValueAsString(bodyObject))).uri(url).header("Content-Type", "application/json").header("Accept", "application/json").build();
        return req;
    }

    protected String doDeleteRequestForString(String requestUrl) throws HttpException {
        HttpRequest req = this.createDeleteRequest(requestUrl);
        try {
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("DELETE " + requestUrl, statusCode);
            }
            String body = response.body();
            return body;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected T doGetRequestForObject(String requestUrl) throws HttpException {
        return (T)this.doGetRequestForObject(requestUrl, this.targetType);
    }

    protected Object doGetRequestForObject(String requestUrl, Class<?> targetType) throws HttpException {
        HttpRequest req = this.createGetRequest(requestUrl);
        try {
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("GET " + requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            Object result = this.mapper.readerFor(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected List<T> doGetRequestForObjectList(String requestUrl) throws HttpException {
        return this.doGetRequestForObjectList(requestUrl, this.targetType, null);
    }

    protected List doGetRequestForObjectList(String requestUrl, Class<?> targetType) throws HttpException {
        return this.doGetRequestForObjectList(requestUrl, targetType, null);
    }

    protected List doGetRequestForObjectList(String requestUrl, Class<?> targetType, Filtering filtering) throws HttpException {
        if (filtering != null) {
            requestUrl = (String)requestUrl + (((String)requestUrl).contains("?") ? "&" : "?") + this.getFilterParamsAsString(filtering.getFilterCriteria());
        }
        HttpRequest req = this.createGetRequest((String)requestUrl);
        try {
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("GET " + (String)requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            List result = (List)this.mapper.readerForListOf(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected PageResponse<T> doGetRequestForPagedObjectList(String requestUrl, PageRequest pageRequest) throws HttpException {
        if (!((String)requestUrl).contains("?")) {
            requestUrl = (String)requestUrl + "?";
        } else if (!((String)requestUrl).endsWith("&")) {
            requestUrl = (String)requestUrl + "&";
        }
        String findParams = this.getFindParamsAsString(pageRequest);
        requestUrl = (String)requestUrl + findParams;
        Filtering filtering = pageRequest.getFiltering();
        if (filtering != null) {
            requestUrl = (String)requestUrl + "&" + this.getFilterParamsAsString(filtering.getFilterCriteria());
        }
        HttpRequest req = this.createGetRequest((String)requestUrl);
        try {
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("GET " + (String)requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            PageResponse result = (PageResponse)this.mapper.readerFor(PageResponse.class).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected PageResponse doGetRequestForPagedObjectList(String requestUrl, PageRequest pageRequest, Class<?> targetType) throws HttpException {
        return this.doGetRequestForPagedObjectList(requestUrl, pageRequest);
    }

    protected String doGetRequestForString(String requestUrl) throws HttpException {
        HttpRequest req = this.createGetRequest(requestUrl);
        try {
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("GET " + requestUrl, statusCode);
            }
            String body = response.body();
            return body;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected <X> SearchPageResponse<X> doGetSearchRequestForPagedObjectList(String requestUrl, SearchPageRequest searchPageRequest, Class<X> type) throws HttpException {
        String searchTerm;
        if (!((String)requestUrl).contains("?")) {
            requestUrl = (String)requestUrl + "?";
        } else if (!((String)requestUrl).endsWith("&")) {
            requestUrl = (String)requestUrl + "&";
        }
        String findParams = this.getFindParamsAsString((PageRequest)searchPageRequest);
        requestUrl = (String)requestUrl + findParams;
        Filtering filtering = searchPageRequest.getFiltering();
        if (filtering != null) {
            requestUrl = (String)requestUrl + "&" + this.getFilterParamsAsString(filtering.getFilterCriteria());
        }
        if ((searchTerm = searchPageRequest.getQuery()) != null) {
            requestUrl = (String)requestUrl + "&searchTerm=" + URLEncoder.encode(searchTerm, StandardCharsets.UTF_8);
        }
        HttpRequest req = this.createGetRequest((String)requestUrl);
        try {
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("GET " + (String)requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            SearchPageResponse result = (SearchPageResponse)this.mapper.readerFor(SearchPageResponse.class).readValue(body);
            result.setQuery(searchTerm);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected SearchPageResponse<T> doGetSearchRequestForPagedObjectList(String requestUrl, SearchPageRequest searchPageRequest) throws HttpException {
        return this.doGetSearchRequestForPagedObjectList(requestUrl, searchPageRequest, this.getClass());
    }

    protected String doPatchRequestForString(String requestUrl) throws HttpException {
        HttpRequest req = this.createPatchRequest(requestUrl);
        try {
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("PATCH " + requestUrl, statusCode);
            }
            String body = response.body();
            return body;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected String doPatchRequestForString(String requestUrl, Object object) throws HttpException {
        try {
            HttpRequest req = this.createPatchRequest(requestUrl, object);
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("PATCH " + requestUrl, statusCode);
            }
            String body = response.body();
            return body;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected T doPostRequestForObject(String requestUrl, T object) throws HttpException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl, object);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("POST " + requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            Object result = this.mapper.readerFor(this.targetType).readValue(body);
            return (T)result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to error", e);
        }
    }

    protected Object doPostRequestForObject(String requestUrl, Object bodyObject, Class<?> targetType) throws HttpException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl, bodyObject);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("POST " + requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null) {
                return null;
            }
            Object result = this.mapper.readerFor(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to error", e);
        }
    }

    protected T doPostRequestForObject(String requestUrl) throws HttpException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("POST " + requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            Object result = this.mapper.readerFor(this.targetType).readValue(body);
            return (T)result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected Object doPostRequestForObject(String requestUrl, Class<?> targetType) throws HttpException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("POST " + requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            Object result = this.mapper.readerFor(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to error", e);
        }
    }

    protected List<T> doPostRequestForObjectList(String requestUrl, List<T> list) throws HttpException {
        return this.doPostRequestForObjectList(requestUrl, list, this.targetType);
    }

    protected List<Class<?>> doPostRequestForObjectList(String requestUrl, List<Class<?>> list, Class<?> targetType) throws HttpException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl, list);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("POST " + requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            List result = (List)this.mapper.readerForListOf(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to error", e);
        }
    }

    protected String doPostRequestForString(String requestUrl) throws HttpException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl);
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("POST " + requestUrl, statusCode);
            }
            String body = response.body();
            return body;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected String doPostRequestForString(String requestUrl, Object object) throws HttpException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl, object);
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("POST " + requestUrl, statusCode);
            }
            String body = response.body();
            return body;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected T doPutRequestForObject(String requestUrl, T object) throws HttpException {
        try {
            HttpRequest req = this.createPutRequest(requestUrl, object);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("PUT " + requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            Object result = this.mapper.readerFor(this.targetType).readValue(body);
            return (T)result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    protected Object doPutRequestForObject(String requestUrl, Object bodyObject, Class<?> targetType) throws HttpException {
        try {
            HttpRequest req = this.createPutRequest(requestUrl, bodyObject);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("PUT " + requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null) {
                return null;
            }
            Object result = this.mapper.readerFor(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to error", e);
        }
    }

    protected List<Class<?>> doPutRequestForObjectList(String requestUrl, List<Class<?>> list, Class<?> targetType) throws HttpException {
        try {
            HttpRequest req = this.createPutRequest(requestUrl, list);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("PUT " + requestUrl, statusCode);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            List result = (List)this.mapper.readerForListOf(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to error", e);
        }
    }

    protected String doPutRequestForString(String requestUrl, Object object) throws HttpException {
        try {
            HttpRequest req = this.createPutRequest(requestUrl, object);
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw CudamiRestErrorDecoder.decode("PUT " + requestUrl, statusCode);
            }
            String body = response.body();
            return body;
        }
        catch (IOException | InterruptedException e) {
            throw new HttpException("Failed to retrieve response due to connection error", e);
        }
    }

    public PageResponse<T> findByLanguageAndInitial(String baseUrl, PageRequest pageRequest, String language, String initial) throws HttpException {
        return this.doGetRequestForPagedObjectList(String.format(baseUrl + "?language=%s&initial=%s", language, initial), pageRequest);
    }

    public PageResponse<T> findByLanguageAndInitial(String baseUrl, int pageNumber, int pageSize, String sortField, String sortDirection, String nullHandling, String language, String initial) throws HttpException {
        Order order = new Order(Direction.fromString((String)sortDirection), sortField, NullHandling.valueOf((String)nullHandling));
        Sorting sorting = new Sorting(new Order[]{order});
        PageRequest pageRequest = new PageRequest(pageNumber, pageSize, sorting);
        return this.findByLanguageAndInitial(baseUrl, pageRequest, language, initial);
    }

    private String getFilterParamsAsString(List<FilterCriterion> filterCriterias) {
        return filterCriterias.stream().map(this::filterCriterionToUrlParam).collect(Collectors.joining("&"));
    }

    private String filterCriterionToUrlParam(FilterCriterion filterCriterion) {
        if (filterCriterion.getOperation() == null) {
            return "";
        }
        String criterion = filterCriterion.getExpression() + "=" + filterCriterion.getOperation() + ":";
        switch (filterCriterion.getOperation().getOperandCount()) {
            case SINGLEVALUE: {
                criterion = criterion + URLEncoder.encode(filterCriterion.getValue().toString(), StandardCharsets.UTF_8);
                break;
            }
            case MIN_MAX_VALUES: {
                criterion = criterion + URLEncoder.encode(filterCriterion.getMinValue().toString(), StandardCharsets.UTF_8) + "," + URLEncoder.encode(filterCriterion.getMaxValue().toString(), StandardCharsets.UTF_8);
                break;
            }
            case MULTIVALUE: {
                criterion = criterion + filterCriterion.getValues().stream().map(value -> URLEncoder.encode(value.toString(), StandardCharsets.UTF_8)).collect(Collectors.joining(","));
                break;
            }
        }
        return criterion;
    }

    private String getFindParamsAsString(PageRequest pageRequest) {
        int pageNumber = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        StringBuilder findParams = new StringBuilder(String.format("pageNumber=%d&pageSize=%d", pageNumber, pageSize));
        Sorting sorting = pageRequest.getSorting();
        if (sorting == null) {
            return findParams.toString();
        }
        List orders = sorting.getOrders();
        if (orders == null || orders.isEmpty()) {
            return findParams.toString();
        }
        String sortBy = orders.stream().map(o -> {
            Direction direction;
            String property = o.getProperty();
            StringBuilder order = new StringBuilder(property);
            Optional subProperty = o.getSubProperty();
            if (subProperty.isPresent()) {
                order.append("_").append((String)subProperty.get());
            }
            if ((direction = o.getDirection()) != null && direction.isDescending()) {
                order.append(".desc");
            } else {
                order.append(".asc");
            }
            NullHandling nullHandling = o.getNullHandling();
            if (nullHandling == NullHandling.NULLS_FIRST) {
                order.append(".nullsfirst");
            } else if (nullHandling == NullHandling.NULLS_LAST) {
                order.append(".nullslast");
            }
            return order.toString();
        }).collect(Collectors.joining(","));
        findParams.append("&sortBy=").append(sortBy);
        return findParams.toString();
    }
}

