/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.resource;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.resource.FileResource;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;

public class CudamiFileResourcesBinaryClient {
    protected final ObjectMapper mapper;
    protected final URI serverUri;

    public CudamiFileResourcesBinaryClient(String serverUrl, ObjectMapper mapper) {
        this.mapper = mapper;
        this.serverUri = URI.create(serverUrl);
    }

    private FileResource doPost(HttpEntity entity) throws TechnicalException {
        try {
            HttpPost post = new HttpPost(this.serverUri + "/v6/files");
            post.setEntity(entity);
            CloseableHttpClient client = HttpClientBuilder.create().build();
            HttpResponse response = client.execute((HttpUriRequest)post);
            if (response.getStatusLine().getStatusCode() == 200) {
                FileResource fileResource = (FileResource)this.mapper.readValue(response.getEntity().getContent(), FileResource.class);
                return fileResource;
            }
            throw new TechnicalException("Error saving uploaded file data");
        }
        catch (IOException ex) {
            throw new TechnicalException("Error posting data to server", (Throwable)ex);
        }
    }

    public FileResource upload(InputStream inputStream, String filename, String contentType) throws TechnicalException {
        try {
            filename = URLEncoder.encode(filename, StandardCharsets.UTF_8.toString());
            HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody(contentType, inputStream, ContentType.create((String)contentType), filename).build();
            return this.doPost(entity);
        }
        catch (Exception ex) {
            throw new TechnicalException("Error saving uploaded file data", (Throwable)ex);
        }
    }

    public FileResource upload(byte[] bytes, String filename, String contentType) throws TechnicalException {
        try {
            filename = URLEncoder.encode(filename, StandardCharsets.UTF_8.toString());
            HttpEntity entity = MultipartEntityBuilder.create().addBinaryBody(contentType, bytes, ContentType.create((String)contentType), filename).build();
            return this.doPost(entity);
        }
        catch (Exception ex) {
            throw new TechnicalException("Error saving uploaded file data", (Throwable)ex);
        }
    }
}

