/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.web;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiWebpagesClient
extends CudamiIdentifiablesClient<Webpage> {
    public CudamiWebpagesClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Webpage.class, mapper, "/v6/webpages");
    }

    public PageResponse<Webpage> findActiveChildren(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/children?active=true", this.baseEndpoint, uuid), pageRequest, Webpage.class);
    }

    public PageResponse<Webpage> findActiveSubpages(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/children?active=true", this.baseEndpoint, uuid), pageRequest);
    }

    public PageResponse<Webpage> findChildren(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/children", this.baseEndpoint, uuid), pageRequest);
    }

    public PageResponse<Webpage> findSubpages(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/children", this.baseEndpoint, uuid), pageRequest);
    }

    public Webpage getActiveByUuid(UUID uuid, Locale locale) throws TechnicalException {
        return (Webpage)this.doGetRequestForObject(String.format("%s/%s?active=true&pLocale=%s", this.baseEndpoint, uuid, locale));
    }

    public List<Webpage> getActiveChildrenTree(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/childrentree?active=true", this.baseEndpoint, uuid));
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID uuid) throws TechnicalException {
        return (BreadcrumbNavigation)this.doGetRequestForObject(String.format("%s/%s/breadcrumb", this.baseEndpoint, uuid), BreadcrumbNavigation.class);
    }

    public List<Webpage> getChildren(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/children", this.baseEndpoint, uuid));
    }

    public List<Webpage> getChildrenTree(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/childrentree", this.baseEndpoint, uuid));
    }

    public Webpage getParent(UUID uuid) throws TechnicalException {
        return (Webpage)this.doGetRequestForObject(String.format("%s/%s/parent", this.baseEndpoint, uuid));
    }

    public List<FileResource> getRelatedFileResources(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/related/fileresources", this.baseEndpoint, uuid), FileResource.class);
    }

    public Website getWebsite(UUID rootWebpageUuid) throws TechnicalException {
        return (Website)this.doGetRequestForObject(String.format("%s/%s/website", this.baseEndpoint, rootWebpageUuid), Website.class);
    }

    public Webpage saveWithParentWebpage(Webpage webpage, UUID parentWebpageUuid) throws TechnicalException {
        return this.doPostRequestForObject(String.format("%s/%s/webpage", this.baseEndpoint, parentWebpageUuid), webpage);
    }

    public Webpage saveWithParentWebsite(Webpage webpage, UUID parentWebsiteUuid) throws TechnicalException {
        return this.doPostRequestForObject(String.format("/v6/websites/%s/webpage", parentWebsiteUuid), webpage);
    }

    public boolean updateChildrenOrder(UUID webpageUuid, List<Webpage> children) throws TechnicalException {
        return Boolean.parseBoolean(this.doPutRequestForString(String.format("%s/%s/children", this.baseEndpoint, webpageUuid), children));
    }
}

