/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.security;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiRestClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.security.User;
import java.net.http.HttpClient;
import java.util.List;

public class CudamiUsersClient
extends CudamiRestClient<User> {
    public CudamiUsersClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, User.class, mapper, "/v6/users");
    }

    public List<User> getActiveAdminUsers() throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s?role=ADMIN&enabled=true", this.baseEndpoint));
    }

    @Override
    public List<User> getAll() throws TechnicalException {
        return this.doGetRequestForObjectList("/v6/users");
    }

    public User getByEmail(String email) throws TechnicalException {
        return (User)this.doGetRequestForObject(String.format("%s?email=%s", this.baseEndpoint, email));
    }
}

