/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.entity;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.Project;
import de.digitalcollections.model.identifiable.entity.work.Item;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.identifiable.resource.ImageFileResource;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiDigitalObjectsClient
extends CudamiEntitiesClient<DigitalObject> {
    public CudamiDigitalObjectsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, DigitalObject.class, mapper, "/v6/digitalobjects");
    }

    public PageResponse<Collection> findActiveCollections(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/collections?active=true", this.baseEndpoint, uuid), pageRequest, Collection.class);
    }

    public PageResponse<Collection> findCollections(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/collections", this.baseEndpoint, uuid), pageRequest, Collection.class);
    }

    public PageResponse<Project> findProjects(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/projects", this.baseEndpoint, uuid), pageRequest, Project.class);
    }

    public PageResponse<DigitalObject> getAllForParent(DigitalObject parent) throws TechnicalException {
        if (parent == null) {
            throw new TechnicalException("Empty parent");
        }
        PageRequest pageRequest = PageRequest.builder().pageNumber(0).pageSize(10000).build();
        return this.getAllForParent(parent, pageRequest);
    }

    public PageResponse<DigitalObject> getAllForParent(DigitalObject parent, PageRequest pageRequest) throws TechnicalException {
        pageRequest.add(Filtering.builder().add(FilterCriterion.builder().withExpression("parent.uuid").isEquals((Object)parent.getUuid()).build()).build());
        return this.find(pageRequest);
    }

    public List<DigitalObject> getAllReduced() throws TechnicalException {
        return this.doGetRequestForObjectList(this.baseEndpoint + "/reduced", DigitalObject.class);
    }

    public List<FileResource> getFileResources(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/fileresources", this.baseEndpoint, uuid), FileResource.class);
    }

    public List<ImageFileResource> getImageFileResources(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/fileresources/images", this.baseEndpoint, uuid), ImageFileResource.class);
    }

    public Item getItem(UUID uuid) throws TechnicalException {
        return (Item)this.doGetRequestForObject(String.format("%s/%s/item", this.baseEndpoint, uuid), Item.class);
    }

    public List<Locale> getLanguagesOfCollections(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/collections/languages", this.baseEndpoint, uuid), Locale.class);
    }

    public List<Locale> getLanguagesOfContainedDigitalObjects(UUID uuid) throws TechnicalException {
        Filtering filtering = Filtering.builder().add(FilterCriterion.builder().withExpression("parent.uuid").isEquals((Object)uuid).build()).build();
        return this.doGetRequestForObjectList(this.baseEndpoint + "/languages", Locale.class, filtering);
    }

    public List<Locale> getLanguagesOfProjects(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/projects/languages", this.baseEndpoint, uuid), Locale.class);
    }

    public List<DigitalObject> getRandomDigitalObjects(int count) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/random?count=%d", this.baseEndpoint, count), DigitalObject.class);
    }

    public List<FileResource> setFileResources(UUID uuid, List fileResources) throws TechnicalException {
        return this.doPostRequestForObjectList(String.format("%s/%s/fileresources", this.baseEndpoint, uuid), fileResources, FileResource.class);
    }
}

