/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.entity.work;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.DigitalObject;
import de.digitalcollections.model.identifiable.entity.work.Item;
import de.digitalcollections.model.identifiable.entity.work.Work;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiItemsClient
extends CudamiEntitiesClient<Item> {
    public CudamiItemsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Item.class, mapper, "/v6/items");
    }

    public Boolean addDigitalObject(UUID itemUuid, UUID digitalObjectUuid) throws TechnicalException {
        return (Boolean)this.doPostRequestForObject(String.format("%s/%s/digitalobjects/%s", this.baseEndpoint, itemUuid, digitalObjectUuid), Boolean.class);
    }

    public boolean addWork(UUID itemUuid, UUID workUuid) throws TechnicalException {
        return (Boolean)this.doPostRequestForObject(String.format("%s/%s/works/%s", this.baseEndpoint, itemUuid, workUuid), Boolean.class);
    }

    public PageResponse<DigitalObject> findDigitalObjects(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/digitalobjects", this.baseEndpoint, uuid), pageRequest, DigitalObject.class);
    }

    public PageResponse<Item> getAllForParent(Item parent) throws TechnicalException {
        if (parent == null) {
            throw new TechnicalException("Empty parent");
        }
        PageRequest pageRequest = PageRequest.builder().pageNumber(0).pageSize(10000).build();
        return this.getAllForParent(parent, pageRequest);
    }

    public PageResponse<Item> getAllForParent(Item parent, PageRequest pageRequest) throws TechnicalException {
        pageRequest.add(Filtering.builder().add(FilterCriterion.builder().withExpression("part_of_item.uuid").isEquals((Object)parent.getUuid()).build()).build());
        return this.find(pageRequest);
    }

    public List<Locale> getLanguagesOfDigitalObjects(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/digitalobjects/languages", this.baseEndpoint, uuid), Locale.class);
    }

    public List getWorks(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/works", this.baseEndpoint, uuid), Work.class);
    }
}

