/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiRestClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.exception.http.client.ResourceNotFoundException;
import de.digitalcollections.model.identifiable.Identifiable;
import de.digitalcollections.model.identifiable.alias.LocalizedUrlAliases;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.NullHandling;
import de.digitalcollections.model.list.sorting.Order;
import de.digitalcollections.model.list.sorting.Sorting;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.codec.binary.Base64;

public class CudamiIdentifiablesClient<I extends Identifiable>
extends CudamiRestClient<I> {
    public CudamiIdentifiablesClient(HttpClient http, String serverUrl, Class<I> identifiableClass, ObjectMapper mapper, String baseEndpoint) {
        super(http, serverUrl, identifiableClass, mapper, baseEndpoint);
    }

    public CudamiIdentifiablesClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Identifiable.class, mapper, "/v6/identifiables");
    }

    public PageResponse<I> findByLanguageAndInitial(PageRequest pageRequest, String language, String initial) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format(this.baseEndpoint + "?language=%s&initial=%s", language, initial), pageRequest);
    }

    public PageResponse<I> findByLanguageAndInitial(int pageNumber, int pageSize, String sortField, String sortDirection, String nullHandling, String language, String initial) throws TechnicalException {
        Order order = new Order(Direction.fromString((String)sortDirection), sortField, NullHandling.valueOf((String)nullHandling));
        Sorting sorting = new Sorting(new Order[]{order});
        PageRequest pageRequest = new PageRequest(pageNumber, pageSize, sorting);
        return this.findByLanguageAndInitial(pageRequest, language, initial);
    }

    public I getByIdentifier(String namespace, String id, Map<String, String> additionalParameters) throws TechnicalException {
        String namespaceAndId = namespace + ":" + id;
        String encodedNamespaceAndId = Base64.encodeBase64URLSafeString((byte[])namespaceAndId.getBytes(StandardCharsets.UTF_8));
        Object expandedAdditionalParameters = "";
        if (additionalParameters != null && !additionalParameters.isEmpty()) {
            expandedAdditionalParameters = "?" + additionalParameters.entrySet().stream().map(e -> (String)e.getKey() + "=" + (String)e.getValue()).collect(Collectors.joining("&"));
        }
        try {
            return (I)((Identifiable)this.doGetRequestForObject(String.format(this.baseEndpoint + "/identifier/%s%s", encodedNamespaceAndId, expandedAdditionalParameters)));
        }
        catch (ResourceNotFoundException e2) {
            return null;
        }
    }

    public I getByIdentifier(String namespace, String id) throws TechnicalException {
        return this.getByIdentifier(namespace, id, null);
    }

    public I getByUuidAndLocale(UUID uuid, Locale locale) throws TechnicalException {
        return this.getByUuidAndLocale(uuid, locale.toString());
    }

    public I getByUuidAndLocale(UUID uuid, String locale) throws TechnicalException {
        try {
            return (I)((Identifiable)this.doGetRequestForObject(String.format(this.baseEndpoint + "/%s?locale=%s", uuid, locale)));
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public List<Locale> getLanguages() throws TechnicalException {
        return this.doGetRequestForObjectList(this.baseEndpoint + "/languages", Locale.class);
    }

    public LocalizedUrlAliases getLocalizedUrlAliases(UUID uuid) throws TechnicalException {
        return (LocalizedUrlAliases)this.doGetRequestForObject(String.format(this.baseEndpoint + "/%s/localizedUrlAliases", uuid), LocalizedUrlAliases.class);
    }
}

