/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.entity.work;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.identifiable.entity.manifestation.Manifestation;
import de.digitalcollections.model.identifiable.entity.work.Work;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.UUID;

public class CudamiWorksClient
extends CudamiEntitiesClient<Work> {
    public CudamiWorksClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Work.class, mapper, "/v6/works");
    }

    public Set<Agent> getCreators(UUID uuid) throws TechnicalException {
        return (Set)((Object)this.doGetRequestForObjectList(String.format("%s/%s/creators", this.baseEndpoint, uuid), DigitalObject.class));
    }

    public PageResponse<Work> findChildren(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format(this.baseEndpoint + "/" + uuid + "/children", new Object[0]), pageRequest);
    }

    public PageResponse<Manifestation> findManifestations(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/manifestations", this.baseEndpoint, uuid), pageRequest, Manifestation.class);
    }

    public List<Locale> getLanguagesOfManifestations(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/manifestations/languages", this.baseEndpoint, uuid), Locale.class);
    }
}

