/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.entity;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.exception.http.client.ResourceNotFoundException;
import de.digitalcollections.model.identifiable.entity.Entity;
import de.digitalcollections.model.identifiable.entity.Topic;
import de.digitalcollections.model.identifiable.resource.FileResource;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiTopicsClient
extends CudamiEntitiesClient<Topic> {
    public CudamiTopicsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Topic.class, mapper, "/v6/topics");
    }

    public PageResponse<Topic> findChildren(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/children", this.baseEndpoint, uuid), pageRequest);
    }

    public PageResponse<Entity> findEntities(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/entities", this.baseEndpoint, uuid), pageRequest, Entity.class);
    }

    public PageResponse<FileResource> findFileResources(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/fileresources", this.baseEndpoint, uuid), pageRequest, FileResource.class);
    }

    public PageResponse<Topic> findSubtopics(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/subtopics", this.baseEndpoint, uuid), pageRequest);
    }

    public PageResponse<Topic> findTopTopics(PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/top", this.baseEndpoint), pageRequest);
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID uuid) throws TechnicalException {
        try {
            return (BreadcrumbNavigation)this.doGetRequestForObject(String.format("%s/%s/breadcrumb", this.baseEndpoint, uuid), BreadcrumbNavigation.class);
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public List<Topic> getChildren(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/children", this.baseEndpoint, uuid));
    }

    public List<Locale> getLanguagesOfEntities(UUID topicUuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/entities/languages", this.baseEndpoint, topicUuid), Locale.class);
    }

    public List<Locale> getLanguagesOfFileResources(UUID topicUuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/fileresources/languages", this.baseEndpoint, topicUuid), Locale.class);
    }

    public List<Locale> getLanguagesOfTopTopics() throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/top/languages", this.baseEndpoint), Locale.class);
    }

    public Topic getParent(UUID uuid) throws TechnicalException {
        return (Topic)this.doGetRequestForObject(String.format("%s/%s/parent", this.baseEndpoint, uuid));
    }

    public List<Topic> getTopicsOfEntity(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/entity/%s", this.baseEndpoint, uuid));
    }

    public List<Topic> getTopicsOfFileResource(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/fileresource/%s", this.baseEndpoint, uuid));
    }

    public boolean removeChild(UUID parentUuid, UUID childUuid) throws TechnicalException {
        try {
            this.doDeleteRequestForString(String.format("%s/%s/children/%s", this.baseEndpoint, parentUuid, childUuid));
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }

    public Topic saveWithParentTopic(Topic subtopic, UUID parentTopicUuid) throws TechnicalException {
        try {
            return this.doPostRequestForObject(String.format("%s/%s/subtopic", this.baseEndpoint, parentTopicUuid), subtopic);
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public List<Entity> setEntities(UUID uuid, List entities) throws TechnicalException {
        return this.doPostRequestForObjectList(String.format("%s/%s/entities", this.baseEndpoint, uuid), entities, Entity.class);
    }

    public List<FileResource> setFileResources(UUID uuid, List fileResources) throws TechnicalException {
        return this.doPostRequestForObjectList(String.format("%s/%s/fileresources", this.baseEndpoint, uuid), fileResources, FileResource.class);
    }
}

