/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.entity;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.exception.http.client.ResourceNotFoundException;
import de.digitalcollections.model.identifiable.entity.Website;
import de.digitalcollections.model.identifiable.web.Webpage;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.net.http.HttpClient;
import java.util.List;
import java.util.UUID;

public class CudamiWebsitesClient
extends CudamiEntitiesClient<Website> {
    public CudamiWebsitesClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Website.class, mapper, "/v6/websites");
    }

    public PageResponse<Webpage> findRootWebpages(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/rootpages", this.baseEndpoint, uuid), pageRequest, Webpage.class);
    }

    public boolean updateRootWebpagesOrder(UUID websiteUuid, List<Webpage> rootpages) throws TechnicalException {
        try {
            this.doPutRequestForString(String.format("%s/%s/rootpages", this.baseEndpoint, websiteUuid), rootpages);
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }
}

