/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.entity.work;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.item.Item;
import de.digitalcollections.model.identifiable.entity.manifestation.Manifestation;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiManifestationsClient
extends CudamiEntitiesClient<Manifestation> {
    public CudamiManifestationsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Manifestation.class, mapper, "/v6/manifestations");
    }

    public PageResponse<Manifestation> findChildren(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format(this.baseEndpoint + "/" + uuid + "/children", new Object[0]), pageRequest);
    }

    public PageResponse<Item> findItems(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format("%s/%s/items", this.baseEndpoint, uuid), pageRequest, Item.class);
    }

    public List<Locale> getLanguagesOfItems(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/items/languages", this.baseEndpoint, uuid), Locale.class);
    }
}

