/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.legal;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiRestClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.exception.http.client.ResourceNotFoundException;
import de.digitalcollections.model.legal.License;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;

public class CudamiLicensesClient
extends CudamiRestClient<License> {
    public CudamiLicensesClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, License.class, mapper, "/v6/licenses");
    }

    public void deleteByUrl(String url) throws TechnicalException, MalformedURLException {
        this.deleteByUrl(URI.create(url).toURL());
    }

    public void deleteByUrl(URL url) throws TechnicalException {
        this.doDeleteRequestForString(String.format("%s?url=%s", this.baseEndpoint, URLEncoder.encode(url.toString(), StandardCharsets.UTF_8)));
    }

    public License getByUrl(String url) throws TechnicalException {
        try {
            return (License)this.doGetRequestForObject(String.format("%s?url=%s", this.baseEndpoint, URLEncoder.encode(url, StandardCharsets.UTF_8)));
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public License getByUrl(URL url) throws TechnicalException {
        return this.getByUrl(url.toString());
    }

    public List<Locale> getLanguages() throws TechnicalException {
        return this.doGetRequestForObjectList(this.baseEndpoint + "/languages", Locale.class);
    }
}

