/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.client;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.exception.http.HttpErrorDecoder;
import de.digitalcollections.model.list.ListRequest;
import de.digitalcollections.model.list.filtering.FilterCriteria;
import de.digitalcollections.model.list.filtering.FilterCriterion;
import de.digitalcollections.model.list.filtering.FilterLogicalOperator;
import de.digitalcollections.model.list.filtering.FilterOperation;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.list.sorting.Direction;
import de.digitalcollections.model.list.sorting.NullHandling;
import de.digitalcollections.model.list.sorting.Sorting;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.net.URI;
import java.net.URLEncoder;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
public abstract class BaseRestClient<T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseRestClient.class);
    protected final String baseEndpoint;
    protected final HttpClient http;
    protected final ObjectMapper mapper;
    protected final ObjectReader reader;
    protected final URI serverUri;
    protected final Class<T> targetType;

    public BaseRestClient(HttpClient http, String serverUrl, Class<T> targetType, ObjectMapper mapper, String baseEndpoint) {
        this.baseEndpoint = baseEndpoint;
        this.http = http;
        this.mapper = mapper;
        this.reader = mapper.reader().forType(targetType);
        this.serverUri = URI.create(serverUrl);
        this.targetType = targetType;
    }

    public T create() throws TechnicalException {
        try {
            return this.targetType.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new TechnicalException("Cannot create new instance of " + this.targetType.getName() + ": " + e, (Throwable)e);
        }
    }

    private HttpRequest createDeleteRequest(String requestUrl) {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("DELETE " + url);
        HttpRequest req = HttpRequest.newBuilder().DELETE().uri(url).header("Accept", "application/json").build();
        return req;
    }

    public URI createFullUri(String requestUrl) {
        return this.serverUri.resolve(this.serverUri.getPath() + requestUrl);
    }

    private HttpRequest createGetRequest(String requestUrl) {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("GET " + url);
        HttpRequest req = HttpRequest.newBuilder().GET().uri(url).header("Accept", "application/json").build();
        return req;
    }

    private HttpRequest createPatchRequest(String requestUrl) {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("PATCH " + url);
        HttpRequest req = HttpRequest.newBuilder().method("PATCH", HttpRequest.BodyPublishers.noBody()).uri(url).header("Accept", "application/json").build();
        return req;
    }

    private HttpRequest createPatchRequest(String requestUrl, Object bodyObject) throws JsonProcessingException {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("PATCH " + url + " with body");
        HttpRequest req = HttpRequest.newBuilder().method("PATCH", HttpRequest.BodyPublishers.ofString(this.mapper.writeValueAsString(bodyObject))).uri(url).header("Content-Type", "application/json").header("Accept", "application/json").build();
        return req;
    }

    private HttpRequest createPostRequest(String requestUrl) throws JsonProcessingException {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("POST " + url);
        HttpRequest req = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.noBody()).uri(url).header("Content-Type", "application/json").header("Accept", "application/json").build();
        return req;
    }

    private HttpRequest createPostRequest(String requestUrl, Object bodyObject) throws JsonProcessingException {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("POST " + url + " with body");
        HttpRequest req = HttpRequest.newBuilder().POST(HttpRequest.BodyPublishers.ofString(this.mapper.writeValueAsString(bodyObject))).uri(url).header("Content-Type", "application/json").header("Accept", "application/json").build();
        return req;
    }

    private HttpRequest createPutRequest(String requestUrl, Object bodyObject) throws JsonProcessingException {
        URI url = this.createFullUri(requestUrl);
        LOGGER.debug("PUT " + url + " with body");
        HttpRequest req = HttpRequest.newBuilder().PUT(HttpRequest.BodyPublishers.ofString(this.mapper.writeValueAsString(bodyObject))).uri(url).header("Content-Type", "application/json").header("Accept", "application/json").build();
        return req;
    }

    protected String doDeleteRequestForString(String requestUrl) throws TechnicalException {
        HttpRequest req = this.createDeleteRequest(requestUrl);
        try {
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("DELETE " + requestUrl), (int)statusCode, response);
            }
            String body = response.body();
            if (body == null || body.isBlank()) {
                return null;
            }
            String result = (String)this.mapper.readerFor(String.class).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    protected T doGetRequestForObject(String requestUrl) throws TechnicalException {
        return (T)this.doGetRequestForObject(requestUrl, this.targetType);
    }

    protected Object doGetRequestForObject(String requestUrl, Class<?> targetType) throws TechnicalException {
        HttpRequest req = this.createGetRequest(requestUrl);
        try {
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("GET " + requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            Object result = this.mapper.readerFor(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    protected List<T> doGetRequestForObjectList(String requestUrl) throws TechnicalException {
        return this.doGetRequestForObjectList(requestUrl, this.targetType, null);
    }

    protected List doGetRequestForObjectList(String requestUrl, Class<?> targetType) throws TechnicalException {
        return this.doGetRequestForObjectList(requestUrl, targetType, null);
    }

    protected List doGetRequestForObjectList(String requestUrl, Class<?> targetType, Filtering filtering) throws TechnicalException {
        if (filtering != null) {
            requestUrl = (String)requestUrl + (((String)requestUrl).contains("?") ? "&" : "?") + this.getFilterParamsAsString(filtering);
        }
        HttpRequest req = this.createGetRequest((String)requestUrl);
        try {
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("GET " + (String)requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            List result = (List)this.mapper.readerForListOf(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    protected PageResponse<T> doGetRequestForPagedObjectList(String requestUrl, PageRequest pageRequest) throws TechnicalException {
        if (!((String)requestUrl).contains("?")) {
            requestUrl = (String)requestUrl + "?";
        } else if (!((String)requestUrl).endsWith("&")) {
            requestUrl = (String)requestUrl + "&";
        }
        String findParams = this.getFindParamsAsString(pageRequest);
        requestUrl = (String)requestUrl + findParams;
        Filtering filtering = pageRequest.getFiltering();
        if (filtering != null) {
            requestUrl = (String)requestUrl + "&" + this.getFilterParamsAsString(filtering);
        }
        HttpRequest req = this.createGetRequest((String)requestUrl);
        try {
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("GET " + (String)requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            PageResponse result = (PageResponse)this.mapper.readerFor(PageResponse.class).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    protected PageResponse doGetRequestForPagedObjectList(String requestUrl, PageRequest pageRequest, Class<?> targetType) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(requestUrl, pageRequest);
    }

    protected String doGetRequestForString(String requestUrl) throws TechnicalException {
        HttpRequest req = this.createGetRequest(requestUrl);
        try {
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("GET " + requestUrl), (int)statusCode, response);
            }
            String body = response.body();
            if (body == null || body.isBlank()) {
                return null;
            }
            String result = (String)this.mapper.readerFor(String.class).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    protected String doPatchRequestForString(String requestUrl) throws TechnicalException {
        HttpRequest req = this.createPatchRequest(requestUrl);
        try {
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("PATCH " + requestUrl), (int)statusCode, response);
            }
            String body = response.body();
            if (body == null || body.isBlank()) {
                return null;
            }
            String result = (String)this.mapper.readerFor(String.class).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    protected String doPatchRequestForString(String requestUrl, Object object) throws TechnicalException {
        try {
            HttpRequest req = this.createPatchRequest(requestUrl, object);
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("PATCH " + requestUrl), (int)statusCode, response);
            }
            String body = response.body();
            if (body == null || body.isBlank()) {
                return null;
            }
            String result = (String)this.mapper.readerFor(String.class).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    protected T doPostRequestForObject(String requestUrl, T object) throws TechnicalException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl, object);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("POST " + requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            Object result = this.mapper.readerFor(this.targetType).readValue(body);
            return (T)result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to error", (Throwable)e);
        }
    }

    protected Object doPostRequestForObject(String requestUrl, Object bodyObject, Class<?> targetType) throws TechnicalException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl, bodyObject);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("POST " + requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null) {
                return null;
            }
            Object result = this.mapper.readerFor(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to error", (Throwable)e);
        }
    }

    protected T doPostRequestForObject(String requestUrl) throws TechnicalException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("POST " + requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            Object result = this.mapper.readerFor(this.targetType).readValue(body);
            return (T)result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    protected Object doPostRequestForObject(String requestUrl, Class<?> targetType) throws TechnicalException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("POST " + requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            Object result = this.mapper.readerFor(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to error", (Throwable)e);
        }
    }

    protected List<T> doPostRequestForObjectList(String requestUrl, List<T> list) throws TechnicalException {
        return this.doPostRequestForObjectList(requestUrl, list, this.targetType);
    }

    protected List<Class<?>> doPostRequestForObjectList(String requestUrl, List<Class<?>> list, Class<?> targetType) throws TechnicalException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl, list);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("POST " + requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            List result = (List)this.mapper.readerForListOf(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to error", (Throwable)e);
        }
    }

    protected String doPostRequestForString(String requestUrl) throws TechnicalException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl);
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("POST " + requestUrl), (int)statusCode, response);
            }
            String body = response.body();
            if (body == null || body.isBlank()) {
                return null;
            }
            String result = (String)this.mapper.readerFor(String.class).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    protected String doPostRequestForString(String requestUrl, Object object) throws TechnicalException {
        try {
            HttpRequest req = this.createPostRequest(requestUrl, object);
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("POST " + requestUrl), (int)statusCode, response);
            }
            String body = response.body();
            if (body == null || body.isBlank()) {
                return null;
            }
            String result = (String)this.mapper.readerFor(String.class).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    protected T doPutRequestForObject(String requestUrl, T object) throws TechnicalException {
        try {
            HttpRequest req = this.createPutRequest(requestUrl, object);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("PUT " + requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            Object result = this.mapper.readerFor(this.targetType).readValue(body);
            return (T)result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    protected Object doPutRequestForObject(String requestUrl, Object bodyObject, Class<?> targetType) throws TechnicalException {
        try {
            HttpRequest req = this.createPutRequest(requestUrl, bodyObject);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("PUT " + requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null) {
                return null;
            }
            Object result = this.mapper.readerFor(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to error", (Throwable)e);
        }
    }

    protected List<Class<?>> doPutRequestForObjectList(String requestUrl, List<Class<?>> list, Class<?> targetType) throws TechnicalException {
        try {
            HttpRequest req = this.createPutRequest(requestUrl, list);
            HttpResponse<byte[]> response = this.http.send(req, HttpResponse.BodyHandlers.ofByteArray());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("PUT " + requestUrl), (int)statusCode, response);
            }
            byte[] body = response.body();
            if (body == null || body.length == 0) {
                return null;
            }
            List result = (List)this.mapper.readerForListOf(targetType).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to error", (Throwable)e);
        }
    }

    protected String doPutRequestForString(String requestUrl, Object object) throws TechnicalException {
        try {
            HttpRequest req = this.createPutRequest(requestUrl, object);
            HttpResponse<String> response = this.http.send(req, HttpResponse.BodyHandlers.ofString());
            Integer statusCode = response.statusCode();
            if (statusCode >= 400) {
                throw HttpErrorDecoder.decode((String)("PUT " + requestUrl), (int)statusCode, response);
            }
            String body = response.body();
            if (body == null || body.isBlank()) {
                return null;
            }
            String result = (String)this.mapper.readerFor(String.class).readValue(body);
            return result;
        }
        catch (IOException | InterruptedException e) {
            throw new TechnicalException("Failed to retrieve response due to connection error", (Throwable)e);
        }
    }

    String filterCriterionToUrlParam(FilterCriterion filterCriterion) {
        Object operand;
        String expression = filterCriterion.getExpression();
        boolean isNativeExpression = filterCriterion.isNativeExpression();
        FilterOperation operation = filterCriterion.getOperation();
        if (expression == null || operation == null) {
            return null;
        }
        Function<Object, String> escapeValue = o -> o.toString().replaceAll("[;{}]", "\\\\$0");
        switch (operation.getOperandCount()) {
            case SINGLEVALUE: {
                operand = URLEncoder.encode(escapeValue.apply(filterCriterion.getValue()), StandardCharsets.UTF_8);
                break;
            }
            case MIN_MAX_VALUES: {
                operand = URLEncoder.encode(escapeValue.apply(filterCriterion.getMinValue()), StandardCharsets.UTF_8) + "," + URLEncoder.encode(escapeValue.apply(filterCriterion.getMaxValue()), StandardCharsets.UTF_8);
                break;
            }
            case MULTIVALUE: {
                operand = filterCriterion.getValues().stream().map(value -> URLEncoder.encode((String)escapeValue.apply(value), StandardCharsets.UTF_8)).collect(Collectors.joining(",")).toString();
                break;
            }
            default: {
                operand = "";
            }
        }
        if (isNativeExpression) {
            expression = URLEncoder.encode("[" + expression + "]", StandardCharsets.UTF_8);
        }
        return expression + ":" + operation + ":" + (String)operand;
    }

    public String getBaseEndpoint() {
        return this.baseEndpoint;
    }

    public String getFilterParamsAsString(Filtering filtering) {
        List filterCriterias = filtering.getFilterCriteriaList();
        boolean simpleShape = filterCriterias.size() == 1 && ((FilterCriteria)filterCriterias.get(0)).getCriterionLink() == FilterLogicalOperator.AND;
        String criteriaTemplate = URLEncoder.encode("{", StandardCharsets.UTF_8) + "${{logicalLink}};{{criterias}}" + URLEncoder.encode("}", StandardCharsets.UTF_8);
        ArrayList<String> criteriaStrings = new ArrayList<String>();
        for (FilterCriteria criteria : filterCriterias) {
            String criteriaString = criteria.stream().filter(Objects::nonNull).map(this::filterCriterionToUrlParam).filter(Objects::nonNull).collect(Collectors.collectingAndThen(Collectors.joining(";"), s -> simpleShape ? s : criteriaTemplate.replace("{{logicalLink}}", Optional.ofNullable(criteria.getCriterionLink()).orElse(FilterLogicalOperator.AND).getOperand()).replace("{{criterias}}", (CharSequence)s)));
            criteriaStrings.add(criteriaString);
        }
        return "filtering=" + String.join((CharSequence)";", criteriaStrings);
    }

    public String getFindParamsAsString(PageRequest pageRequest) {
        int pageNumber = pageRequest.getPageNumber();
        int pageSize = pageRequest.getPageSize();
        StringBuilder findParams = new StringBuilder(String.format("pageNumber=%d&pageSize=%d", pageNumber, pageSize));
        String sortParams = this.getSortParams((ListRequest)pageRequest);
        if (sortParams == null) {
            return findParams.toString();
        }
        findParams.append("&").append(sortParams);
        return findParams.toString();
    }

    public String getSortParams(ListRequest listRequest) {
        Sorting sorting = listRequest.getSorting();
        if (sorting == null) {
            return null;
        }
        List orders = sorting.getOrders();
        if (orders == null || orders.isEmpty()) {
            return null;
        }
        String sortBy = orders.stream().map(o -> {
            Direction direction;
            String property = o.getProperty();
            StringBuilder order = new StringBuilder(property);
            Optional subProperty = o.getSubProperty();
            if (subProperty.isPresent()) {
                order.append("_").append((String)subProperty.get());
            }
            if ((direction = o.getDirection()) != null && direction.isDescending()) {
                order.append(".desc");
            } else {
                order.append(".asc");
            }
            NullHandling nullHandling = o.getNullHandling();
            if (nullHandling == NullHandling.NULLS_FIRST) {
                order.append(".nullsfirst");
            } else if (nullHandling == NullHandling.NULLS_LAST) {
                order.append(".nullslast");
            }
            boolean ignoreCase = o.isIgnoreCase();
            if (ignoreCase) {
                order.append(".ignorecase");
            }
            return order.toString();
        }).collect(Collectors.joining(","));
        return "sortBy=" + sortBy;
    }
}

