/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.entity;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.exception.http.client.ResourceNotFoundException;
import de.digitalcollections.model.identifiable.entity.Collection;
import de.digitalcollections.model.identifiable.entity.agent.CorporateBody;
import de.digitalcollections.model.identifiable.entity.digitalobject.DigitalObject;
import de.digitalcollections.model.list.filtering.Filtering;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.list.paging.PageResponse;
import de.digitalcollections.model.view.BreadcrumbNavigation;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiCollectionsClient
extends CudamiEntitiesClient<Collection> {
    public CudamiCollectionsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Collection.class, mapper, "/v6/collections");
    }

    public boolean addDigitalObject(UUID collectionUuid, UUID digitalObjectUuid) throws TechnicalException {
        try {
            this.doPostRequestForString(String.format(this.baseEndpoint + "/%s/digitalobjects/%s", collectionUuid, digitalObjectUuid));
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean addDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) throws TechnicalException {
        try {
            this.doPostRequestForString(String.format(this.baseEndpoint + "/%s/digitalobjects", collectionUuid), digitalObjects);
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean addSubcollection(UUID collectionUuid, UUID subcollectionUuid) throws TechnicalException {
        try {
            this.doPostRequestForString(String.format(this.baseEndpoint + "/%s/subcollections/%s", collectionUuid, subcollectionUuid));
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean addSubcollections(UUID collectionUuid, List<Collection> subcollections) throws TechnicalException {
        try {
            this.doPostRequestForString(String.format(this.baseEndpoint + "/%s/subcollections", collectionUuid), subcollections);
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }

    public PageResponse<Collection> findActive(PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format(this.baseEndpoint + "?active=true", new Object[0]), pageRequest);
    }

    public PageResponse<Collection> findActiveSubcollections(UUID uuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format(this.baseEndpoint + "/%s/subcollections?active=true", uuid), pageRequest, Collection.class);
    }

    public PageResponse<DigitalObject> findDigitalObjects(UUID collectionUuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format(this.baseEndpoint + "/%s/digitalobjects", collectionUuid), pageRequest, DigitalObject.class);
    }

    public List<CorporateBody> findRelatedCorporateBodies(UUID uuid, Filtering filtering) throws TechnicalException {
        if (filtering.getFilterCriterionFor("predicate") == null) {
            throw new IllegalArgumentException("Filter criterion 'predicate' is required");
        }
        return this.doGetRequestForObjectList(String.format(this.baseEndpoint + "/%s/related/corporatebodies", uuid), CorporateBody.class, filtering);
    }

    public PageResponse<Collection> findSubcollections(UUID collectionUuid, PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(String.format(this.baseEndpoint + "/%s/subcollections", collectionUuid), pageRequest, Collection.class);
    }

    public PageResponse<Collection> findTopCollections(PageRequest pageRequest) throws TechnicalException {
        return this.doGetRequestForPagedObjectList(this.baseEndpoint + "/top", pageRequest);
    }

    public Collection getActiveByUuid(UUID uuid, Locale locale) throws TechnicalException {
        try {
            return (Collection)this.doGetRequestForObject(String.format(this.baseEndpoint + "/%s?active=true&pLocale=%s", uuid, locale));
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public BreadcrumbNavigation getBreadcrumbNavigation(UUID uuid) throws TechnicalException {
        try {
            return (BreadcrumbNavigation)this.doGetRequestForObject(String.format(this.baseEndpoint + "/%s/breadcrumb", uuid), BreadcrumbNavigation.class);
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public List<Locale> getLanguagesOfTopCollections() throws TechnicalException {
        return this.doGetRequestForObjectList(this.baseEndpoint + "/top/languages", Locale.class);
    }

    public Collection getParent(UUID uuid) throws TechnicalException {
        return (Collection)this.doGetRequestForObject(String.format(this.baseEndpoint + "/%s/parent", uuid), Collection.class);
    }

    public List<Collection> getParents(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format(this.baseEndpoint + "/%s/parents", uuid));
    }

    public boolean removeDigitalObject(UUID collectionUuid, UUID digitalObjectUuid) throws TechnicalException {
        try {
            this.doDeleteRequestForString(String.format(this.baseEndpoint + "/%s/digitalobjects/%s", collectionUuid, digitalObjectUuid));
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean removeSubcollection(UUID collectionUuid, UUID subcollectionUuid) throws TechnicalException {
        try {
            this.doDeleteRequestForString(String.format(this.baseEndpoint + "/%s/subcollections/%s", collectionUuid, subcollectionUuid));
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }

    public Collection saveWithParentCollection(Collection collection, UUID parentCollectionUuid) throws TechnicalException {
        return this.doPostRequestForObject(String.format(this.baseEndpoint + "/%s/collection", parentCollectionUuid), collection);
    }

    public boolean setDigitalObjects(UUID collectionUuid, List<DigitalObject> digitalObjects) throws TechnicalException {
        try {
            this.doPutRequestForObject(String.format(this.baseEndpoint + "/%s/digitalobjects", collectionUuid), digitalObjects, String.class);
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }
}

