/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.entity;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.identifiable.entity.CudamiEntitiesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.exception.http.client.ResourceNotFoundException;
import de.digitalcollections.model.identifiable.entity.Article;
import de.digitalcollections.model.identifiable.entity.agent.Agent;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.UUID;

public class CudamiArticlesClient
extends CudamiEntitiesClient<Article> {
    public CudamiArticlesClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Article.class, mapper, "/v6/articles");
    }

    public Article getByUuid(UUID uuid, Locale locale) throws TechnicalException {
        try {
            if (locale != null) {
                return (Article)this.doGetRequestForObject(String.format(this.baseEndpoint + "/%s?pLocale=%s", uuid, locale));
            }
            return (Article)this.doGetRequestForObject(String.format(this.baseEndpoint + "/%s", uuid));
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public boolean removeCreator(UUID articleUuid, UUID agentUuid) throws TechnicalException {
        try {
            this.doDeleteRequestForString(String.format(this.baseEndpoint + "/%s/creators/%s", articleUuid, agentUuid));
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }

    public boolean addCreators(UUID articleUuid, List<Agent> agents) throws TechnicalException {
        try {
            this.doPostRequestForString(String.format(this.baseEndpoint + "/%s/creators", articleUuid), agents);
        }
        catch (ResourceNotFoundException e) {
            return false;
        }
        return true;
    }
}

