/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.semantic;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.CudamiRestClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.identifiable.entity.Article;
import de.digitalcollections.model.list.ListRequest;
import de.digitalcollections.model.list.buckets.Bucket;
import de.digitalcollections.model.list.buckets.BucketObjectsRequest;
import de.digitalcollections.model.list.buckets.BucketObjectsResponse;
import de.digitalcollections.model.list.buckets.BucketsRequest;
import de.digitalcollections.model.list.buckets.BucketsResponse;
import de.digitalcollections.model.list.paging.PageRequest;
import de.digitalcollections.model.semantic.Headword;
import java.net.http.HttpClient;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class CudamiHeadwordsClient
extends CudamiRestClient<Headword> {
    public CudamiHeadwordsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Headword.class, mapper, "/v6/headwords");
    }

    public BucketObjectsResponse<Headword> findBucketObjects(BucketObjectsRequest<Headword> bucketObjectsRequest) throws TechnicalException {
        BucketObjectsResponse result;
        Object url = String.format("%s/bucketobjects", this.baseEndpoint);
        Bucket bucket = bucketObjectsRequest.getBucket();
        if (bucket != null && bucket.getStartObject() != null && bucket.getEndObject() != null) {
            Headword startObject = (Headword)bucket.getStartObject();
            Headword endObject = (Headword)bucket.getEndObject();
            url = (String)url + "?startId=" + startObject.getUuid();
            url = (String)url + "&endId=" + endObject.getUuid();
            url = (String)url + "&" + this.getFindParamsAsString((PageRequest)bucketObjectsRequest);
            result = (BucketObjectsResponse)this.doGetRequestForObject((String)url, BucketObjectsResponse.class);
        } else {
            result = new BucketObjectsResponse(bucketObjectsRequest, new ArrayList());
        }
        return result;
    }

    public BucketsResponse<Headword> findBuckets(BucketsRequest<Headword> bucketsRequest) throws TechnicalException {
        int numberOfBuckets = bucketsRequest.getNumberOfBuckets();
        Object url = String.format("%s/buckets?numberOfBuckets=%d", this.baseEndpoint, numberOfBuckets);
        Bucket parentBucket = bucketsRequest.getParentBucket();
        if (parentBucket != null) {
            Headword startObject = (Headword)parentBucket.getStartObject();
            Headword endObject = (Headword)parentBucket.getEndObject();
            url = (String)url + "&startId=" + startObject.getUuid();
            url = (String)url + "&endId=" + endObject.getUuid();
        }
        url = (String)url + "&" + this.getSortParams((ListRequest)bucketsRequest);
        BucketsResponse result = (BucketsResponse)this.doGetRequestForObject((String)url, BucketsResponse.class);
        return result;
    }

    public List getRandomHeadwords(int count) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/random?count=%d", this.baseEndpoint, count), Headword.class);
    }

    public List getRelatedArticles(UUID uuid) throws TechnicalException {
        return this.doGetRequestForObjectList(String.format("%s/%s/related/articles", this.baseEndpoint, uuid), Article.class);
    }
}

