/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.client.BaseRestClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.exception.http.client.ResourceNotFoundException;
import java.net.http.HttpClient;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;

public class CudamiLocalesClient
extends BaseRestClient<Locale> {
    public CudamiLocalesClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Locale.class, mapper, "/v6/locales");
    }

    public List<String> getAllLanguages() throws TechnicalException {
        return this.doGetRequestForObjectList("/v6/languages", String.class);
    }

    public List<Locale> getAllLanguagesAsLocales() throws TechnicalException {
        List<Locale> allLocales = this.getAllLocales();
        return allLocales.stream().filter(l -> l.getCountry().isBlank()).collect(Collectors.toList());
    }

    public List<Locale> getAllLocales() throws TechnicalException {
        return this.doGetRequestForObjectList(this.baseEndpoint, Locale.class);
    }

    public Locale getDefaultLanguage() throws TechnicalException {
        try {
            return (Locale)this.doGetRequestForObject("/v6/languages/default");
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    public String getDefaultLocale() throws TechnicalException {
        try {
            return this.doGetRequestForString(this.baseEndpoint + "/default");
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }
}

