/*
 * Decompiled with CFR 0.152.
 */
package de.digitalcollections.cudami.client.identifiable.entity.semantic;

import com.fasterxml.jackson.databind.ObjectMapper;
import de.digitalcollections.cudami.client.identifiable.CudamiIdentifiablesClient;
import de.digitalcollections.model.exception.TechnicalException;
import de.digitalcollections.model.exception.http.client.ResourceNotFoundException;
import de.digitalcollections.model.identifiable.semantic.Subject;
import java.net.http.HttpClient;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.Locale;
import org.apache.commons.codec.binary.Base64;

public class CudamiSubjectsClient
extends CudamiIdentifiablesClient<Subject> {
    public CudamiSubjectsClient(HttpClient http, String serverUrl, ObjectMapper mapper) {
        super(http, serverUrl, Subject.class, mapper, "/v6/subjects");
    }

    public Subject getByTypeAndIdentifier(String type, String namespace, String id) throws TechnicalException {
        String typeAndNamespaceAndId = type + ":" + namespace + ":" + id;
        String encodedTypeAndNamespaceAndId = Base64.encodeBase64URLSafeString((byte[])typeAndNamespaceAndId.getBytes(StandardCharsets.UTF_8));
        try {
            return (Subject)this.doGetRequestForObject(String.format(this.baseEndpoint + "/identifier/%s", encodedTypeAndNamespaceAndId));
        }
        catch (ResourceNotFoundException e) {
            return null;
        }
    }

    @Override
    public List<Locale> getLanguages() throws TechnicalException {
        return this.doGetRequestForObjectList(this.baseEndpoint + "/languages", Locale.class);
    }
}

